import lxml.etree as ET
from device.service.driver_api._Driver import RESOURCE_ENDPOINTS, RESOURCE_INTERFACES, RESOURCE_NETWORK_INSTANCES
from .Components import get_filter_components, extract_port_data
from .Interfaces import get_filter_interfaces, extract_interface_data
from .NetworkInstance import get_filter_network_instances, extract_network_instance_data

RESOURCE_FUNCTIONS = {
    RESOURCE_ENDPOINTS         : (get_filter_components, extract_port_data),
    RESOURCE_INTERFACES        : (get_filter_interfaces, extract_interface_data),
    RESOURCE_NETWORK_INSTANCES : (get_filter_network_instances, extract_network_instance_data),
}

ALL_RESOURCES = [
    RESOURCE_ENDPOINTS,
    RESOURCE_INTERFACES,
    RESOURCE_NETWORK_INSTANCES,
]

def get_filter(resource_key : str, *args, **kwargs):
    filter_function = RESOURCE_FUNCTIONS.get(resource_key)
    return None if filter_function is None else filter_function[0](*args, **kwargs)

def extract_data(resource_key : str, xml_data : ET.Element, *args, **kwargs):
    extract_function = RESOURCE_FUNCTIONS.get(resource_key)
    return [(resource_key, xml_data)] if extract_function is None else extract_function[1](xml_data, *args, **kwargs)
