import lxml.etree as ET
from typing import Collection, Dict

def add_value_from_tag(container : Dict, name: str, value : ET.Element, cast=None) -> None:
    if value is None or value.text is None: return
    value = value.text
    if cast is not None: value = cast(value)
    container[name] = value

def add_value_from_collection(container : Dict, name: str, value : Collection) -> None:
    if value is None or len(value) == 0: return
    container[name] = value
