/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MinMax {
    private final double maxX;
    private final double maxY;
    private final double minX;
    private final double minY;

    public static MinMax getEmpty(boolean bl) {
        if (bl) {
            return new MinMax(0.0, 0.0, 0.0, 0.0);
        }
        return new MinMax(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public String toString() {
        return "(" + this.minX + "," + this.minY + ")->(" + this.maxX + "," + this.maxY + ")";
    }

    public static MinMax fromMutable(MinMaxMutable minMaxMutable) {
        return new MinMax(minMaxMutable.getMinX(), minMaxMutable.getMinY(), minMaxMutable.getMaxX(), minMaxMutable.getMaxY());
    }

    private MinMax(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
    }

    public MinMax addPoint(Point2D point2D) {
        return this.addPoint(point2D.getX(), point2D.getY());
    }

    public MinMax addPoint(double d, double d2) {
        return new MinMax(Math.min(d, this.minX), Math.min(d2, this.minY), Math.max(d, this.maxX), Math.max(d2, this.maxY));
    }

    public static MinMax fromMax(double d, double d2) {
        return MinMax.getEmpty(true).addPoint(d, d2);
    }

    public static MinMax fromDim(Dimension2D dimension2D) {
        return MinMax.fromMax(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
    }

    public void drawGrey(UGraphic uGraphic) {
        HtmlColor htmlColor = HtmlColorUtils.GRAY;
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor));
        uGraphic = uGraphic.apply(new UTranslate(this.minX, this.minY));
        uGraphic.draw(new URectangle(this.getWidth(), this.getHeight()));
    }

    public MinMax translate(UTranslate uTranslate) {
        double d = uTranslate.getDx();
        double d2 = uTranslate.getDy();
        return new MinMax(this.minX + d, this.minY + d2, this.maxX + d, this.maxY + d2);
    }
}

