/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.context.model;

import eu.teraflow.policy.common.Util;
import eu.teraflow.policy.kpi_sample_types.model.KpiSampleType;
import java.util.List;

public class EndPoint {
    private final EndPointId endPointId;
    private final String endPointType;
    private final List<KpiSampleType> kpiSampleTypes;
    private final Location endPointLocation;

    public EndPoint(
            EndPointId endPointId,
            String endPointType,
            List<KpiSampleType> kpiSampleTypes,
            Location endPointLocation) {
        this.endPointId = endPointId;
        this.endPointType = endPointType;
        this.kpiSampleTypes = kpiSampleTypes;
        this.endPointLocation = endPointLocation;
    }

    public EndPointId getEndPointId() {
        return endPointId;
    }

    public String getEndPointType() {
        return endPointType;
    }

    public List<KpiSampleType> getKpiSampleTypes() {
        return kpiSampleTypes;
    }

    public Location getEndPointLocation() {
        return endPointLocation;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{%s, endPointType:\"%s\", [%s], %s}",
                getClass().getSimpleName(),
                endPointId,
                endPointType,
                Util.toString(kpiSampleTypes),
                endPointLocation);
    }
}
