package eu.teraflow.policy;

import context.ContextOuterClass;
import io.quarkus.grpc.GrpcService;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;
import policy.Policy;

@GrpcService
public class PolicyGatewayImpl implements PolicyGateway {

    private final PolicyService policyService;

    @Inject
    public PolicyGatewayImpl(PolicyService policyService) {
        this.policyService = policyService;
    }

    @Override
    public Uni<Policy.PolicyRuleState> policyAdd(Policy.PolicyRule request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Policy.PolicyRuleState.newBuilder()
                                        .setPolicyRuleId(request.getPolicyRuleId().getUuid())
                                        .build());
    }

    @Override
    public Uni<Policy.PolicyRuleState> policyUpdate(Policy.PolicyRule request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Policy.PolicyRuleState.newBuilder()
                                        .setPolicyRuleId(request.getPolicyRuleId().getUuid())
                                        .build());
    }

    @Override
    public Uni<Policy.PolicyRuleState> policyDelete(Policy.PolicyRule request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Policy.PolicyRuleState.newBuilder()
                                        .setPolicyRuleId(request.getPolicyRuleId().getUuid())
                                        .build());
    }

    @Override
    public Uni<Policy.PolicyRule> getPolicy(Policy.PolicyRuleId request) {
        return Uni.createFrom()
                .item(() -> Policy.PolicyRule.newBuilder().setPolicyRuleId(request).build());
    }

    @Override
    public Uni<Policy.PolicyRuleList> getPolicyByDeviceId(ContextOuterClass.DeviceId request) {

        return Uni.createFrom().item(() -> Policy.PolicyRuleList.newBuilder().build());
    }

    @Override
    public Uni<Policy.PolicyRuleList> getPolicyByServiceId(ContextOuterClass.ServiceId request) {

        return Uni.createFrom().item(() -> Policy.PolicyRuleList.newBuilder().build());
    }
}
