#!/bin/bash
# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


rm -rf tmp/exec

echo "Collecting logs for IP..."
mkdir -p tmp/exec/ip
kubectl --namespace tfs-ip logs deployment/contextservice     -c server   > tmp/exec/ip/context.log
kubectl --namespace tfs-ip logs deployment/deviceservice      -c server   > tmp/exec/ip/device.log
kubectl --namespace tfs-ip logs deployment/pathcompservice    -c frontend > tmp/exec/ip/pathcomp-frontend.log
kubectl --namespace tfs-ip logs deployment/pathcompservice    -c backend  > tmp/exec/ip/pathcomp-backend.log
kubectl --namespace tfs-ip logs deployment/serviceservice     -c server   > tmp/exec/ip/service.log
kubectl --namespace tfs-ip logs deployment/nbiservice         -c server   > tmp/exec/ip/nbi.log
kubectl --namespace tfs-ip logs deployment/vnt-managerservice -c server   > tmp/exec/ip/vntm.log
printf "\n"

echo "Collecting logs for IP..."
mkdir -p tmp/exec/opt
kubectl --namespace tfs-opt logs deployment/contextservice  -c server   > tmp/exec/opt/context.log
kubectl --namespace tfs-opt logs deployment/deviceservice   -c server   > tmp/exec/opt/device.log
kubectl --namespace tfs-opt logs deployment/pathcompservice -c frontend > tmp/exec/opt/pathcomp-frontend.log
kubectl --namespace tfs-opt logs deployment/pathcompservice -c backend  > tmp/exec/opt/pathcomp-backend.log
kubectl --namespace tfs-opt logs deployment/serviceservice  -c server   > tmp/exec/opt/service.log
kubectl --namespace tfs-opt logs deployment/nbiservice      -c server   > tmp/exec/opt/nbi.log
printf "\n"

echo "Collecting logs for E2E..."
mkdir -p tmp/exec/e2e
kubectl --namespace tfs-e2e logs deployment/contextservice          -c server   > tmp/exec/e2e/context.log
kubectl --namespace tfs-e2e logs deployment/deviceservice           -c server   > tmp/exec/e2e/device.log
kubectl --namespace tfs-e2e logs deployment/pathcompservice         -c frontend > tmp/exec/e2e/pathcomp-frontend.log
kubectl --namespace tfs-e2e logs deployment/pathcompservice         -c backend  > tmp/exec/e2e/pathcomp-backend.log
kubectl --namespace tfs-e2e logs deployment/serviceservice          -c server   > tmp/exec/e2e/service.log
kubectl --namespace tfs-e2e logs deployment/nbiservice              -c server   > tmp/exec/e2e/nbi.log
kubectl --namespace tfs-e2e logs deployment/e2e-orchestratorservice -c server   > tmp/exec/e2e/e2eorch.log
printf "\n"

echo "Done!"
