/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GF256Poly;

public final class GF256 {
    public static final GF256 QR_CODE_FIELD = new GF256(285);
    public static final GF256 DATA_MATRIX_FIELD = new GF256(301);
    private final int[] expTable = new int[256];
    private final int[] logTable = new int[256];
    private final GF256Poly zero;
    private final GF256Poly one;

    private GF256(int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < 256; ++n2) {
            this.expTable[n2] = n3;
            if ((n3 <<= 1) < 256) continue;
            n3 ^= n;
        }
        for (n2 = 0; n2 < 255; ++n2) {
            this.logTable[this.expTable[n2]] = n2;
        }
        this.zero = new GF256Poly(this, new int[]{0});
        this.one = new GF256Poly(this, new int[]{1});
    }

    GF256Poly getZero() {
        return this.zero;
    }

    GF256Poly getOne() {
        return this.one;
    }

    GF256Poly buildMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.zero;
        }
        int[] nArray = new int[n + 1];
        nArray[0] = n2;
        return new GF256Poly(this, nArray);
    }

    static int addOrSubtract(int n, int n2) {
        return n ^ n2;
    }

    int exp(int n) {
        return this.expTable[n];
    }

    int log(int n) {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[n];
    }

    int inverse(int n) {
        if (n == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[255 - this.logTable[n]];
    }

    int multiply(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = this.logTable[n] + this.logTable[n2];
        return this.expTable[(n3 & 0xFF) + (n3 >>> 8)];
    }
}

