# ETSI TeraFlowSDN Controller Tutorials


## Abstract
This document provides a walkthrough on how to prepare your environment for executing and contributing to the
[ETSI TeraFlowSDN OSG](https://tfs.etsi.org/).

This walkthrough makes some reasonable assumptions to simplify the deployment of the ETSI TeraFlowSDN controller, the
execution of experiments and tests, and development of new contributions. In particular, we assume:

- [VirtualBox](https://www.virtualbox.org/) version 6.1.34 r150636
- [VSCode](https://code.visualstudio.com/) with the "Remote SSH" extension
- VM software:
  - [Ubuntu Server 20.04 LTS](https://releases.ubuntu.com/20.04/)
  - [MicroK8s](https://microk8s.io/)


## Contact
If your environment does not fit with the proposed assumptions and you experience some trouble preparing it to work
with the ETSI TeraFlowSDN controller, contact the ETSI TeraFlowSDN OSG team through
[Slack](https://join.slack.com/t/teraflowsdn/shared_invite/zt-18gc5jvkh-1_DEZHFhxeuOqzJZPq~U~A)


## Table of Content:
- [1. Deployment Guide](./1-0-deployment.md)
  - [1.1. Create VM for the TeraFlowSDN controller](./1-1-create-vm.md)
  - [1.2. Install MicroK8s Kubernetes platform](./1-2-install-microk8s.md)
  - [1.3. Deploy TeraFlowSDN over MicroK8s](./1-3-deploy-tfs.md)
  - [1.4. Access TeraFlowSDN WebUI and Grafana Dashboards](./1-4-access-webui.md)
- [2. Run Experiments Guide (WORK IN PROGRESS)](./2-0-run-experiments.md)
  - [2.1. Configure the Python environment](./2-1-python-environment.md)
  - [2.2. Execute OFC'22 Experiment (WORK IN PROGRESS)](./2-2-ofc22.md)
  - [2.3. Execute OECC/PSC'22 Experiment (WORK IN PROGRESS)](./2-3-oeccpsc22.md)
- [3. Development Guide (WORK IN PROGRESS)](./3-0-development.md)
  - [3.1. Configure VSCode and Connect to the VM](./3-1-configure-vscode.md)
  - [3.2. Development Commands, Tricks, and Hints (WORK IN PROGRESS)](./3-2-develop-cth.md)
