class MultipleResultsForQueryException(Exception):
    def __init__(self, query_fields, driver_names):
        super().__init__('Multiple Drivers({}) satisfy QueryFields({})'.format(str(driver_names), str(query_fields)))

class UnsatisfiedQueryException(Exception):
    def __init__(self, query_fields):
        super().__init__('No Driver satisfies QueryFields({})'.format(str(query_fields)))

class UnsupportedDriverClassException(Exception):
    def __init__(self, driver_class_name):
        super().__init__('Class({}) is not a subclass of _Driver'.format(str(driver_class_name)))

class UnsupportedQueryFieldException(Exception):
    def __init__(self, unsupported_query_fields, driver_class_name=None):
        if driver_class_name:
            msg = 'QueryFields({}) specified by Driver({}) are not supported'.format(
                str(unsupported_query_fields), str(driver_class_name))
        else:
            msg = 'QueryFields({}) specified in query are not supported'.format(str(unsupported_query_fields))
        super().__init__(msg)

class UnsupportedQueryFieldValueException(Exception):
    def __init__(self, query_field_name, query_field_value, allowed_query_field_values, driver_class_name=None):
        if driver_class_name:
            msg = 'QueryField({}={}) specified by Driver({}) is not supported. Allowed values are {}'.format(
                str(query_field_name), str(query_field_value), str(driver_class_name), str(allowed_query_field_values))
        else:
            msg = 'QueryField({}={}) specified in query is not supported. Allowed values are {}'.format(
                str(query_field_name), str(query_field_value), str(allowed_query_field_values))
        super().__init__(msg)
