# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class ingress_bandwidth_profile(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-link-tp/ingress-bandwidth-profile. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The bandwidth profile used in the ingress direction.
  """
  __slots__ = ('_path_helper', '_extmethods', '__bandwidth_profile_type','__CIR','__CBS','__EIR','__EBS','__color_aware','__coupling_flag',)

  _yang_name = 'ingress-bandwidth-profile'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bandwidth_profile_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="bandwidth-profile-type", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:bandwidth-profile-type', is_config=True)
    self.__CIR = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    self.__CBS = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    self.__EIR = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    self.__EBS = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    self.__color_aware = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="color-aware", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__coupling_flag = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="coupling-flag", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-link-tp', 'ingress-bandwidth-profile']

  def _get_bandwidth_profile_type(self):
    """
    Getter method for bandwidth_profile_type, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/bandwidth_profile_type (etht-types:bandwidth-profile-type)

    YANG Description: The type of bandwidth profile.
    """
    return self.__bandwidth_profile_type
      
  def _set_bandwidth_profile_type(self, v, load=False):
    """
    Setter method for bandwidth_profile_type, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/bandwidth_profile_type (etht-types:bandwidth-profile-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bandwidth_profile_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bandwidth_profile_type() directly.

    YANG Description: The type of bandwidth profile.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="bandwidth-profile-type", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:bandwidth-profile-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bandwidth_profile_type must be of a type compatible with etht-types:bandwidth-profile-type""",
          'defined-type': "etht-types:bandwidth-profile-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="bandwidth-profile-type", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:bandwidth-profile-type', is_config=True)""",
        })

    self.__bandwidth_profile_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bandwidth_profile_type(self):
    self.__bandwidth_profile_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:mef-10-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2697-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-2698-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:rfc-4115-bwp': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="bandwidth-profile-type", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:bandwidth-profile-type', is_config=True)


  def _get_CIR(self):
    """
    Getter method for CIR, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/CIR (uint64)

    YANG Description: Committed Information Rate in Kbps
    """
    return self.__CIR
      
  def _set_CIR(self, v, load=False):
    """
    Setter method for CIR, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/CIR (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_CIR is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_CIR() directly.

    YANG Description: Committed Information Rate in Kbps
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """CIR must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)""",
        })

    self.__CIR = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_CIR(self):
    self.__CIR = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)


  def _get_CBS(self):
    """
    Getter method for CBS, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/CBS (uint64)

    YANG Description: Committed Burst Size in in KBytes
    """
    return self.__CBS
      
  def _set_CBS(self, v, load=False):
    """
    Setter method for CBS, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/CBS (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_CBS is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_CBS() directly.

    YANG Description: Committed Burst Size in in KBytes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """CBS must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)""",
        })

    self.__CBS = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_CBS(self):
    self.__CBS = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="CBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)


  def _get_EIR(self):
    """
    Getter method for EIR, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/EIR (uint64)

    YANG Description: Excess Information Rate in Kbps
In case of RFC 2698, PIR = CIR + EIR
    """
    return self.__EIR
      
  def _set_EIR(self, v, load=False):
    """
    Setter method for EIR, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/EIR (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_EIR is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_EIR() directly.

    YANG Description: Excess Information Rate in Kbps
In case of RFC 2698, PIR = CIR + EIR
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """EIR must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)""",
        })

    self.__EIR = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_EIR(self):
    self.__EIR = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EIR", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)


  def _get_EBS(self):
    """
    Getter method for EBS, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/EBS (uint64)

    YANG Description: Excess Burst Size in KBytes.
 In case of RFC 2698, PBS = CBS + EBS
    """
    return self.__EBS
      
  def _set_EBS(self, v, load=False):
    """
    Setter method for EBS, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/EBS (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_EBS is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_EBS() directly.

    YANG Description: Excess Burst Size in KBytes.
 In case of RFC 2698, PBS = CBS + EBS
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """EBS must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)""",
        })

    self.__EBS = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_EBS(self):
    self.__EBS = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="EBS", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=True)


  def _get_color_aware(self):
    """
    Getter method for color_aware, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/color_aware (boolean)

    YANG Description: Indicates weather the color-mode is
color-aware or color-blind.
    """
    return self.__color_aware
      
  def _set_color_aware(self, v, load=False):
    """
    Setter method for color_aware, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/color_aware (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_color_aware is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_color_aware() directly.

    YANG Description: Indicates weather the color-mode is
color-aware or color-blind.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="color-aware", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """color_aware must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="color-aware", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__color_aware = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_color_aware(self):
    self.__color_aware = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="color-aware", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_coupling_flag(self):
    """
    Getter method for coupling_flag, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/coupling_flag (boolean)

    YANG Description: Coupling Flag.
    """
    return self.__coupling_flag
      
  def _set_coupling_flag(self, v, load=False):
    """
    Setter method for coupling_flag, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile/coupling_flag (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_coupling_flag is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_coupling_flag() directly.

    YANG Description: Coupling Flag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="coupling-flag", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """coupling_flag must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="coupling-flag", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__coupling_flag = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_coupling_flag(self):
    self.__coupling_flag = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="coupling-flag", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)

  bandwidth_profile_type = __builtin__.property(_get_bandwidth_profile_type, _set_bandwidth_profile_type)
  CIR = __builtin__.property(_get_CIR, _set_CIR)
  CBS = __builtin__.property(_get_CBS, _set_CBS)
  EIR = __builtin__.property(_get_EIR, _set_EIR)
  EBS = __builtin__.property(_get_EBS, _set_EBS)
  color_aware = __builtin__.property(_get_color_aware, _set_color_aware)
  coupling_flag = __builtin__.property(_get_coupling_flag, _set_coupling_flag)

  __choices__ = {'direction': {'asymmetrical': ['bandwidth_profile_type', 'CIR', 'CBS', 'EIR', 'EBS', 'color_aware', 'coupling_flag']}}
  _pyangbind_elements = OrderedDict([('bandwidth_profile_type', bandwidth_profile_type), ('CIR', CIR), ('CBS', CBS), ('EIR', EIR), ('EBS', EBS), ('color_aware', color_aware), ('coupling_flag', coupling_flag), ])


