# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class ietf_network_topology(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network-topology - based on the path /ietf-network-topology. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines a common base model for a network topology,
augmenting the base network data model with links to connect
nodes, as well as termination points to terminate links
on nodes.

Copyright (c) 2018 IETF Trust and the persons identified as
authors of the code.  All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, is permitted pursuant to, and subject
to the license terms contained in, the Simplified BSD License
set forth in Section 4.c of the IETF Trust's Legal Provisions
Relating to IETF Documents
(https://trustee.ietf.org/license-info).

This version of this YANG module is part of RFC 8345;
see the RFC itself for full legal notices.
  """
  _pyangbind_elements = {}

  

from . import networks
class ietf_network(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /ietf-network. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines a common base data model for a collection
of nodes in a network.  Node definitions are further used
in network topologies and inventories.

Copyright (c) 2018 IETF Trust and the persons identified as
authors of the code.  All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, is permitted pursuant to, and subject
to the license terms contained in, the Simplified BSD License
set forth in Section 4.c of the IETF Trust's Legal Provisions
Relating to IETF Documents
(https://trustee.ietf.org/license-info).

This version of this YANG module is part of RFC 8345;
see the RFC itself for full legal notices.
  """
  __slots__ = ('_path_helper', '_extmethods', '__networks',)

  _yang_name = 'ietf-network'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__networks = YANGDynClass(base=networks.networks, is_container='container', yang_name="networks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_networks(self):
    """
    Getter method for networks, mapped from YANG variable /networks (container)

    YANG Description: Serves as a top-level container for a list of networks.
    """
    return self.__networks
      
  def _set_networks(self, v, load=False):
    """
    Setter method for networks, mapped from YANG variable /networks (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_networks is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_networks() directly.

    YANG Description: Serves as a top-level container for a list of networks.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=networks.networks, is_container='container', yang_name="networks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """networks must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=networks.networks, is_container='container', yang_name="networks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)""",
        })

    self.__networks = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_networks(self):
    self.__networks = YANGDynClass(base=networks.networks, is_container='container', yang_name="networks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)

  networks = __builtin__.property(_get_networks, _set_networks)


  _pyangbind_elements = OrderedDict([('networks', networks), ])


class ietf_te_topology(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-te-topology - based on the path /ietf-te-topology. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This YANG module defines a TE topology model for representing,
retrieving, and manipulating technology-agnostic TE topologies.

Copyright (c) 2020 IETF Trust and the persons identified as
authors of the code.  All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, is permitted pursuant to, and subject to
the license terms contained in, the Simplified BSD License set
forth in Section 4.c of the IETF Trust's Legal Provisions
Relating to IETF Documents
(https://trustee.ietf.org/license-info).

This version of this YANG module is part of RFC 8795; see the
RFC itself for full legal notices.
  """
  _pyangbind_elements = {}

  

class ietf_otn_topology(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-otn-topology - based on the path /ietf-otn-topology. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines a protocol independent Layer 1/ODU topology
data model. The model fully conforms
to the Network Management Datastore Architecture (NMDA).

Copyright (c) 2023 IETF Trust and the persons identified
as authors of the code.  All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, is permitted pursuant to, and subject
to the license terms contained in, the Revised BSD License
set forth in Section 4.c of the IETF Trust's Legal Provisions
Relating to IETF Documents
(https://trustee.ietf.org/license-info).

This version of this YANG module is part of RFC XXXX; see
the RFC itself for full legal notices.

The key words 'MUST', 'MUST NOT', 'REQUIRED', 'SHALL', 'SHALL
NOT', 'SHOULD', 'SHOULD NOT', 'RECOMMENDED', 'NOT RECOMMENDED',
'MAY', and 'OPTIONAL' in this document are to be interpreted as
described in BCP 14 (RFC 2119) (RFC 8174) when, and only when,
they appear in all capitals, as shown here.
  """
  _pyangbind_elements = {}

  

class ietf_eth_te_topology(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-eth-te-topology - based on the path /ietf-eth-te-topology. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines a YANG data model for describing
layer-2 Ethernet transport topologies. The model fully
conforms to the Network Management Datastore
Architecture (NMDA).

Copyright (c) 2023 IETF Trust and the persons identified
as authors of the code.  All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, is permitted pursuant to, and subject
to the license terms contained in, the Revised BSD License
set forth in Section 4.c of the IETF Trust's Legal Provisions
Relating to IETF Documents
(https://trustee.ietf.org/license-info).

This version of this YANG module is part of RFC XXXX; see
the RFC itself for full legal notices.

The key words 'MUST', 'MUST NOT', 'REQUIRED', 'SHALL', 'SHALL
NOT', 'SHOULD', 'SHOULD NOT', 'RECOMMENDED', 'NOT RECOMMENDED',
'MAY', and 'OPTIONAL' in this document are to be interpreted as
described in BCP 14 (RFC 2119) (RFC 8174) when, and only when,
they appear in all capitals, as shown here.
  """
  _pyangbind_elements = {}

  

