from typing import Dict, List, Set, Union

def get_dict(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> Dict:
    return keys.get(str_key, None)

def get_or_create_dict(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> Dict:
    container = keys.get(str_key, None)
    if container is None: container = keys.setdefault(str_key, dict())
    if not isinstance(container, dict):
        raise Exception('Key({:s}, {:s}) is not a dict'.format(str(type(container).__name__), str(str_key)))
    return container

def get_list(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> List:
    return keys.get(str_key, None)

def get_or_create_list(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> List:
    container = keys.get(str_key, None)
    if container is None: container = keys.setdefault(str_key, list())
    if not isinstance(container, list):
        raise Exception('Key({:s}, {:s}) is not a list'.format(str(type(container).__name__), str(str_key)))
    return container

def get_set(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> Set:
    return keys.get(str_key, None)

def get_or_create_set(keys : Dict[str, Union[Dict, List, Set]], str_key : str) -> Set:
    container = keys.get(str_key, None)
    if container is None: container = keys.setdefault(str_key, set())
    if not isinstance(container, set):
        raise Exception('Key({:s}, {:s}) is not a set'.format(str(type(container).__name__), str(str_key)))
    return container
