import copy
from context.client.ContextClient import ContextClient
from context.proto.context_pb2 import Context, Device, Link, Service, Topology
from context.tests.example_objects import (
    CONTEXT, TOPOLOGY,
    DEVICE1, DEVICE1_ID, DEVICE2, DEVICE2_ID, DEVICE3, DEVICE3_ID,
    LINK_DEV1_DEV2, LINK_DEV1_DEV2_ID, LINK_DEV1_DEV3, LINK_DEV1_DEV3_ID, LINK_DEV2_DEV3, LINK_DEV2_DEV3_ID,
    SERVICE_DEV1_DEV2, SERVICE_DEV1_DEV3, SERVICE_DEV2_DEV3)

def populate(address, port):
    client = ContextClient(address=address, port=port)

    client.SetContext(Context(**CONTEXT))
    client.SetTopology(Topology(**TOPOLOGY))
    client.SetDevice(Device(**DEVICE1))
    client.SetDevice(Device(**DEVICE2))
    client.SetDevice(Device(**DEVICE3))

    client.SetLink(Link(**LINK_DEV1_DEV2))
    client.SetLink(Link(**LINK_DEV1_DEV3))
    client.SetLink(Link(**LINK_DEV2_DEV3))

    TOPOLOGY_WITH_DEVICES_AND_LINKS = copy.deepcopy(TOPOLOGY)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['device_ids'].append(DEVICE1_ID)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['device_ids'].append(DEVICE2_ID)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['device_ids'].append(DEVICE3_ID)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['link_ids'].append(LINK_DEV1_DEV2_ID)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['link_ids'].append(LINK_DEV1_DEV3_ID)
    TOPOLOGY_WITH_DEVICES_AND_LINKS['link_ids'].append(LINK_DEV2_DEV3_ID)
    client.SetTopology(Topology(**TOPOLOGY_WITH_DEVICES_AND_LINKS))

    client.SetService(Service(**SERVICE_DEV1_DEV2))
    client.SetService(Service(**SERVICE_DEV1_DEV3))
    client.SetService(Service(**SERVICE_DEV2_DEV3))
