# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_connectivity_connection_ref import TapiConnectivityConnectionRef  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityRouteRef(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, connection_uuid: str=None, route_local_id: str=None):  # noqa: E501
        """TapiConnectivityRouteRef - a model defined in Swagger

        :param connection_uuid: The connection_uuid of this TapiConnectivityRouteRef.  # noqa: E501
        :type connection_uuid: str
        :param route_local_id: The route_local_id of this TapiConnectivityRouteRef.  # noqa: E501
        :type route_local_id: str
        """
        self.swagger_types = {
            'connection_uuid': str,
            'route_local_id': str
        }

        self.attribute_map = {
            'connection_uuid': 'connection-uuid',
            'route_local_id': 'route-local-id'
        }
        self._connection_uuid = connection_uuid
        self._route_local_id = route_local_id

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityRouteRef':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.RouteRef of this TapiConnectivityRouteRef.  # noqa: E501
        :rtype: TapiConnectivityRouteRef
        """
        return util.deserialize_model(dikt, cls)

    @property
    def connection_uuid(self) -> str:
        """Gets the connection_uuid of this TapiConnectivityRouteRef.

        none  # noqa: E501

        :return: The connection_uuid of this TapiConnectivityRouteRef.
        :rtype: str
        """
        return self._connection_uuid

    @connection_uuid.setter
    def connection_uuid(self, connection_uuid: str):
        """Sets the connection_uuid of this TapiConnectivityRouteRef.

        none  # noqa: E501

        :param connection_uuid: The connection_uuid of this TapiConnectivityRouteRef.
        :type connection_uuid: str
        """

        self._connection_uuid = connection_uuid

    @property
    def route_local_id(self) -> str:
        """Gets the route_local_id of this TapiConnectivityRouteRef.

        none  # noqa: E501

        :return: The route_local_id of this TapiConnectivityRouteRef.
        :rtype: str
        """
        return self._route_local_id

    @route_local_id.setter
    def route_local_id(self, route_local_id: str):
        """Sets the route_local_id of this TapiConnectivityRouteRef.

        none  # noqa: E501

        :param route_local_id: The route_local_id of this TapiConnectivityRouteRef.
        :type route_local_id: str
        """

        self._route_local_id = route_local_id
