# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class tunnel_termination_point(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/statistics/tunnel-termination-point. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains statistics attributes at the TE TTP level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__disables','__enables','__maintenance_clears','__maintenance_sets','__modifies','__downs','__ups','__in_service_clears','__in_service_sets',)

  _yang_name = 'tunnel-termination-point'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__downs = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__ups = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__in_service_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__in_service_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'statistics', 'tunnel-termination-point']

  def _get_disables(self):
    """
    Getter method for disables, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/disables (yang:counter32)

    YANG Description: Number of times that a TTP was disabled.
    """
    return self.__disables
      
  def _set_disables(self, v, load=False):
    """
    Setter method for disables, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/disables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_disables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_disables() directly.

    YANG Description: Number of times that a TTP was disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """disables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__disables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_disables(self):
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_enables(self):
    """
    Getter method for enables, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/enables (yang:counter32)

    YANG Description: Number of times that a TTP was enabled.
    """
    return self.__enables
      
  def _set_enables(self, v, load=False):
    """
    Setter method for enables, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/enables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enables() directly.

    YANG Description: Number of times that a TTP was enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__enables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enables(self):
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_clears(self):
    """
    Getter method for maintenance_clears, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/maintenance_clears (yang:counter32)

    YANG Description: Number of times that a TTP was taken out of maintenance.
    """
    return self.__maintenance_clears
      
  def _set_maintenance_clears(self, v, load=False):
    """
    Setter method for maintenance_clears, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/maintenance_clears (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_clears is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_clears() directly.

    YANG Description: Number of times that a TTP was taken out of maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_clears must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_clears = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_clears(self):
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_sets(self):
    """
    Getter method for maintenance_sets, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/maintenance_sets (yang:counter32)

    YANG Description: Number of times that a TTP was put in maintenance.
    """
    return self.__maintenance_sets
      
  def _set_maintenance_sets(self, v, load=False):
    """
    Setter method for maintenance_sets, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/maintenance_sets (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_sets() directly.

    YANG Description: Number of times that a TTP was put in maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_sets must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_sets(self):
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_modifies(self):
    """
    Getter method for modifies, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/modifies (yang:counter32)

    YANG Description: Number of times that a TTP was modified.
    """
    return self.__modifies
      
  def _set_modifies(self, v, load=False):
    """
    Setter method for modifies, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/modifies (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_modifies is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_modifies() directly.

    YANG Description: Number of times that a TTP was modified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """modifies must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__modifies = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_modifies(self):
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_downs(self):
    """
    Getter method for downs, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/downs (yang:counter32)

    YANG Description: Number of times that a TTP was set to an operational state
of 'down'.
    """
    return self.__downs
      
  def _set_downs(self, v, load=False):
    """
    Setter method for downs, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/downs (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_downs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_downs() directly.

    YANG Description: Number of times that a TTP was set to an operational state
of 'down'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """downs must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__downs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_downs(self):
    self.__downs = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_ups(self):
    """
    Getter method for ups, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/ups (yang:counter32)

    YANG Description: Number of times that a TTP was set to an operational state
of 'up'.
    """
    return self.__ups
      
  def _set_ups(self, v, load=False):
    """
    Setter method for ups, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/ups (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ups() directly.

    YANG Description: Number of times that a TTP was set to an operational state
of 'up'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ups must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__ups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ups(self):
    self.__ups = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_in_service_clears(self):
    """
    Getter method for in_service_clears, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/in_service_clears (yang:counter32)

    YANG Description: Number of times that a TTP was taken out of service
(TE tunnel was released).
    """
    return self.__in_service_clears
      
  def _set_in_service_clears(self, v, load=False):
    """
    Setter method for in_service_clears, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/in_service_clears (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_service_clears is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_service_clears() directly.

    YANG Description: Number of times that a TTP was taken out of service
(TE tunnel was released).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_service_clears must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__in_service_clears = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_service_clears(self):
    self.__in_service_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_in_service_sets(self):
    """
    Getter method for in_service_sets, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/in_service_sets (yang:counter32)

    YANG Description: Number of times that a TTP was put in service by a TE
tunnel (TE tunnel was set up).
    """
    return self.__in_service_sets
      
  def _set_in_service_sets(self, v, load=False):
    """
    Setter method for in_service_sets, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point/in_service_sets (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_service_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_service_sets() directly.

    YANG Description: Number of times that a TTP was put in service by a TE
tunnel (TE tunnel was set up).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_service_sets must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__in_service_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_service_sets(self):
    self.__in_service_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="in-service-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

  disables = __builtin__.property(_get_disables)
  enables = __builtin__.property(_get_enables)
  maintenance_clears = __builtin__.property(_get_maintenance_clears)
  maintenance_sets = __builtin__.property(_get_maintenance_sets)
  modifies = __builtin__.property(_get_modifies)
  downs = __builtin__.property(_get_downs)
  ups = __builtin__.property(_get_ups)
  in_service_clears = __builtin__.property(_get_in_service_clears)
  in_service_sets = __builtin__.property(_get_in_service_sets)


  _pyangbind_elements = OrderedDict([('disables', disables), ('enables', enables), ('maintenance_clears', maintenance_clears), ('maintenance_sets', maintenance_sets), ('modifies', modifies), ('downs', downs), ('ups', ups), ('in_service_clears', in_service_clears), ('in_service_sets', in_service_sets), ])


