import json, logging, time
from ..api.context.OperationalStatus import OperationalStatus
from ..api.Database import Database

LOGGER = logging.getLogger(__name__)

def sequence(database : Database):
    database.clear_all()

    with database:
        context = database.context('ctx-test').create()
        topology = context.topology('base-topo').create()

        device_1 = topology.device('dev1').create(
            device_type='ROADM', device_config='<config/>', device_operational_status=OperationalStatus.ENABLED)
        endpoint_dev1_to_dev2 = device_1.endpoint('to-dev2').create(port_type='WDM')
        endpoint_dev1_to_dev3 = device_1.endpoint('to-dev3').create(port_type='WDM')
        endpoint_dev1_to_dev4 = device_1.endpoint('to-dev4').create(port_type='WDM')

        device_2 = topology.device('dev2').create(
            device_type='ROADM', device_config='<config/>', device_operational_status=OperationalStatus.ENABLED)
        endpoint_dev2_to_dev1 = device_2.endpoint('to-dev1').create(port_type='WDM')
        endpoint_dev2_to_dev3 = device_2.endpoint('to-dev3').create(port_type='WDM')
        endpoint_dev2_to_dev4 = device_2.endpoint('to-dev4').create(port_type='WDM')

        device_3 = topology.device('dev3').create(
            device_type='ROADM', device_config='<config/>', device_operational_status=OperationalStatus.ENABLED)
        endpoint_dev3_to_dev1 = device_3.endpoint('to-dev1').create(port_type='WDM')
        endpoint_dev3_to_dev2 = device_3.endpoint('to-dev2').create(port_type='WDM')
        endpoint_dev3_to_dev4 = device_3.endpoint('to-dev4').create(port_type='WDM')

        device_4 = topology.device('dev4').create(
            device_type='ROADM', device_config='<config/>', device_operational_status=OperationalStatus.ENABLED)
        endpoint_dev4_to_dev1 = device_4.endpoint('to-dev1').create(port_type='WDM')
        endpoint_dev4_to_dev2 = device_4.endpoint('to-dev2').create(port_type='WDM')
        endpoint_dev4_to_dev3 = device_4.endpoint('to-dev3').create(port_type='WDM')

        link_dev1_to_dev2 = topology.link('dev1/to-dev2 ==> dev2/to-dev1').create()
        link_dev1_to_dev2.endpoint('dev1/to-dev2').create(endpoint_dev1_to_dev2)
        link_dev1_to_dev2.endpoint('dev2/to-dev1').create(endpoint_dev2_to_dev1)

        link_dev1_to_dev3 = topology.link('dev1/to-dev3 ==> dev3/to-dev1').create()
        link_dev1_to_dev3.endpoint('dev1/to-dev3').create(endpoint_dev1_to_dev3)
        link_dev1_to_dev3.endpoint('dev3/to-dev1').create(endpoint_dev3_to_dev1)

        link_dev1_to_dev4 = topology.link('dev1/to-dev4 ==> dev4/to-dev1').create()
        link_dev1_to_dev4.endpoint('dev1/to-dev4').create(endpoint_dev1_to_dev4)
        link_dev1_to_dev4.endpoint('dev4/to-dev1').create(endpoint_dev4_to_dev1)

        link_dev2_to_dev1 = topology.link('dev2/to-dev1 ==> dev1/to-dev2').create()
        link_dev2_to_dev1.endpoint('dev2/to-dev1').create(endpoint_dev2_to_dev1)
        link_dev2_to_dev1.endpoint('dev1/to-dev2').create(endpoint_dev1_to_dev2)

        link_dev2_to_dev3 = topology.link('dev2/to-dev3 ==> dev3/to-dev2').create()
        link_dev2_to_dev3.endpoint('dev2/to-dev3').create(endpoint_dev2_to_dev3)
        link_dev2_to_dev3.endpoint('dev3/to-dev2').create(endpoint_dev3_to_dev2)

        link_dev2_to_dev4 = topology.link('dev2/to-dev4 ==> dev4/to-dev2').create()
        link_dev2_to_dev4.endpoint('dev2/to-dev4').create(endpoint_dev2_to_dev4)
        link_dev2_to_dev4.endpoint('dev4/to-dev2').create(endpoint_dev4_to_dev2)

        link_dev3_to_dev1 = topology.link('dev3/to-dev1 ==> dev1/to-dev3').create()
        link_dev3_to_dev1.endpoint('dev3/to-dev1').create(endpoint_dev3_to_dev1)
        link_dev3_to_dev1.endpoint('dev1/to-dev3').create(endpoint_dev1_to_dev3)

        link_dev3_to_dev2 = topology.link('dev3/to-dev2 ==> dev2/to-dev3').create()
        link_dev3_to_dev2.endpoint('dev3/to-dev2').create(endpoint_dev3_to_dev2)
        link_dev3_to_dev2.endpoint('dev2/to-dev3').create(endpoint_dev2_to_dev3)

        link_dev3_to_dev4 = topology.link('dev3/to-dev4 ==> dev4/to-dev3').create()
        link_dev3_to_dev4.endpoint('dev3/to-dev4').create(endpoint_dev3_to_dev4)
        link_dev3_to_dev4.endpoint('dev4/to-dev3').create(endpoint_dev4_to_dev3)

        link_dev4_to_dev1 = topology.link('dev4/to-dev1 ==> dev1/to-dev4').create()
        link_dev4_to_dev1.endpoint('dev4/to-dev1').create(endpoint_dev4_to_dev1)
        link_dev4_to_dev1.endpoint('dev1/to-dev4').create(endpoint_dev1_to_dev4)

        link_dev4_to_dev2 = topology.link('dev4/to-dev2 ==> dev2/to-dev4').create()
        link_dev4_to_dev2.endpoint('dev4/to-dev2').create(endpoint_dev4_to_dev2)
        link_dev4_to_dev2.endpoint('dev2/to-dev4').create(endpoint_dev2_to_dev4)

        link_dev4_to_dev3 = topology.link('dev4/to-dev3 ==> dev3/to-dev4').create()
        link_dev4_to_dev3.endpoint('dev4/to-dev3').create(endpoint_dev4_to_dev3)
        link_dev4_to_dev3.endpoint('dev3/to-dev4').create(endpoint_dev3_to_dev4)

        LOGGER.info('Dump:')
        for entry in database.dump():
            LOGGER.info('  {}'.format(entry))

    with database:
        t0 = time.time()
        context = database.context('ctx-test').create()
        json_context = context.dump()
        t1 = time.time()
        LOGGER.info(json.dumps(json_context))
        LOGGER.info('Dump elapsed: {}'.format(1000.0 * (t1-t0)))

    with database:
        database.context('ctx-test').delete()
        LOGGER.info('Dump:')
        for entry in database.dump():
            LOGGER.info('  {}'.format(entry))
