/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.geom.Point2D;
import org.stathissideris.ascii2image.graphics.ShapeEdge;

public class ShapePoint
extends Point2D.Float {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_ROUND = 1;
    private boolean locked = false;
    private int type = 0;

    public ShapePoint() {
    }

    public ShapePoint(float f, float f2) {
        super(f, f2);
        this.type = 0;
    }

    public ShapePoint(float f, float f2, int n) {
        super(f, f2);
        this.type = n;
    }

    public ShapePoint(ShapePoint shapePoint) {
        this(shapePoint.x, shapePoint.y, shapePoint.type);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isInLineWith(ShapePoint shapePoint) {
        if (this.x == shapePoint.x) {
            return true;
        }
        return this.y == shapePoint.y;
    }

    public boolean isWithinEdge(ShapeEdge shapeEdge) {
        if (shapeEdge.isHorizontal()) {
            if (this.x >= shapeEdge.getStartPoint().x && this.x <= shapeEdge.getEndPoint().x) {
                return true;
            }
            return this.x >= shapeEdge.getEndPoint().x && this.x <= shapeEdge.getStartPoint().x;
        }
        if (shapeEdge.isVertical()) {
            if (this.y >= shapeEdge.getStartPoint().y && this.y <= shapeEdge.getEndPoint().y) {
                return true;
            }
            return this.y >= shapeEdge.getEndPoint().y && this.y <= shapeEdge.getStartPoint().y;
        }
        throw new RuntimeException("Cannot calculate is ShapePoint is within sloped edge");
    }

    public boolean isNorthOf(ShapePoint shapePoint) {
        return this.y < shapePoint.y;
    }

    public boolean isSouthOf(ShapePoint shapePoint) {
        return this.y > shapePoint.y;
    }

    public boolean isWestOf(ShapePoint shapePoint) {
        return this.x < shapePoint.x;
    }

    public boolean isEastOf(ShapePoint shapePoint) {
        return this.x > shapePoint.x;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void assign(ShapePoint shapePoint) {
        this.x = shapePoint.x;
        this.y = shapePoint.y;
    }

    public void moveTo(ShapePoint shapePoint) {
        if (this.locked) {
            return;
        }
        this.x = shapePoint.x;
        this.y = shapePoint.y;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }
}

