/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.License;

public class PSystemLicense
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();

    PSystemLicense() throws IOException {
        this.strings.addAll(License.getCurrent().getText());
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        return this.getGraphicStrings().exportDiagram(outputStream, fileFormatOption);
    }

    public static PSystemLicense create() throws IOException {
        return new PSystemLicense();
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        return new GraphicStrings(this.strings, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, null, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(License)", this.getClass());
    }
}

