/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class BodyEnhanced2
implements TextBlock {
    private TextBlock area2;
    private final FontConfiguration titleConfig;
    private final Display rawBody2;
    private final ISkinSimple spriteContainer;
    private final HorizontalAlignment align;

    public BodyEnhanced2(Display display, FontParam fontParam, ISkinSimple iSkinSimple, HorizontalAlignment horizontalAlignment, UFont uFont, HtmlColor htmlColor) {
        this.rawBody2 = display;
        this.spriteContainer = iSkinSimple;
        this.titleConfig = new FontConfiguration(uFont, htmlColor);
        this.align = horizontalAlignment;
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock textBlock, char c, TextBlock textBlock2) {
        if (c == '\u0000') {
            return textBlock;
        }
        if (textBlock2 == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 0.0, 4.0), c);
        }
        Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
        TextBlockLineBefore textBlockLineBefore = new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 0.0, 6.0, dimension2D.getHeight() / 2.0, 4.0), c, textBlock2);
        return TextBlockUtils.withMargin(textBlockLineBefore, 0.0, 0.0, dimension2D.getHeight() / 2.0, 0.0);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area2 != null) {
            return this.area2;
        }
        ArrayList<TextBlock> arrayList = new ArrayList<TextBlock>();
        char c = '\u0000';
        TextBlock textBlock = null;
        Display display = Display.empty();
        for (CharSequence charSequence : this.rawBody2) {
            if (BodyEnhanced2.isBlockSeparator(((Object)charSequence).toString())) {
                arrayList.add(this.decorate(stringBounder, this.getTextBlock(display, stringBounder), c, textBlock));
                c = charSequence.charAt(0);
                textBlock = this.getTitle(((Object)charSequence).toString(), this.spriteContainer);
                display = Display.empty();
                continue;
            }
            display = display.add(charSequence);
        }
        arrayList.add(this.decorate(stringBounder, this.getTextBlock(display, stringBounder), c, textBlock));
        this.area2 = arrayList.size() == 1 ? (TextBlock)arrayList.get(0) : new TextBlockVertical2(arrayList, this.align);
        return this.area2;
    }

    private TextBlock getTextBlock(Display display, StringBounder stringBounder) {
        TextBlock textBlock = TextBlockUtils.create(display, this.titleConfig, this.align, this.spriteContainer);
        return textBlock;
    }

    public static boolean isBlockSeparator(String string) {
        if (string.startsWith("--") && string.endsWith("--")) {
            return true;
        }
        if (string.startsWith("==") && string.endsWith("==")) {
            return true;
        }
        if (string.startsWith("..") && string.endsWith("..")) {
            return true;
        }
        return string.startsWith("__") && string.endsWith("__");
    }

    private TextBlock getTitle(String string, ISkinSimple iSkinSimple) {
        if (string.length() <= 4) {
            return null;
        }
        string = string.substring(2, string.length() - 2).trim();
        return TextBlockUtils.create(Display.getWithNewlines(string), this.titleConfig, HorizontalAlignment.LEFT, iSkinSimple);
    }

    public void drawU(UGraphic uGraphic) {
        this.getArea(uGraphic.getStringBounder()).drawU(uGraphic);
    }
}

