# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import interface_switching_capability
from . import geolocation
from . import otn_ltp
from . import client_svc
class te(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/te. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates TE support.
  """
  __slots__ = ('_path_helper', '_extmethods', '__admin_status','__name','__interface_switching_capability','__inter_domain_plug_id','__inter_layer_lock_id','__oper_status','__geolocation','__otn_ltp','__client_svc',)

  _yang_name = 'te'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)
    self.__interface_switching_capability = YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    self.__inter_domain_plug_id = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="inter-domain-plug-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)
    self.__inter_layer_lock_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="inter-layer-lock-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)
    self.__geolocation = YANGDynClass(base=geolocation.geolocation, is_container='container', yang_name="geolocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__otn_ltp = YANGDynClass(base=otn_ltp.otn_ltp, is_container='container', yang_name="otn-ltp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)
    self.__client_svc = YANGDynClass(base=client_svc.client_svc, is_container='container', yang_name="client-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'te']

  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /networks/network/node/termination_point/te/admin_status (te-types:te-admin-status)

    YANG Description: The administrative state of the LTP.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /networks/network/node/termination_point/te/admin_status (te-types:te-admin-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The administrative state of the LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with te-types:te-admin-status""",
          'defined-type': "te-types:te-admin-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /networks/network/node/termination_point/te/name (string)

    YANG Description: A descriptive name for the LTP.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /networks/network/node/termination_point/te/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: A descriptive name for the LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)


  def _get_interface_switching_capability(self):
    """
    Getter method for interface_switching_capability, mapped from YANG variable /networks/network/node/termination_point/te/interface_switching_capability (list)

    YANG Description: List of ISCDs for this link.
    """
    return self.__interface_switching_capability
      
  def _set_interface_switching_capability(self, v, load=False):
    """
    Setter method for interface_switching_capability, mapped from YANG variable /networks/network/node/termination_point/te/interface_switching_capability (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_switching_capability is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_switching_capability() directly.

    YANG Description: List of ISCDs for this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_switching_capability must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__interface_switching_capability = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_switching_capability(self):
    self.__interface_switching_capability = YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)


  def _get_inter_domain_plug_id(self):
    """
    Getter method for inter_domain_plug_id, mapped from YANG variable /networks/network/node/termination_point/te/inter_domain_plug_id (binary)

    YANG Description: A network-wide unique number that identifies on the
network a connection that supports a given inter-domain
TE link.  This is a more flexible alternative to specifying
'remote-te-node-id' and 'remote-te-link-tp-id' on a TE link
when the provider either does not know 'remote-te-node-id'
and 'remote-te-link-tp-id' or needs to give the client the
flexibility to mix and match multiple topologies.
    """
    return self.__inter_domain_plug_id
      
  def _set_inter_domain_plug_id(self, v, load=False):
    """
    Setter method for inter_domain_plug_id, mapped from YANG variable /networks/network/node/termination_point/te/inter_domain_plug_id (binary)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inter_domain_plug_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inter_domain_plug_id() directly.

    YANG Description: A network-wide unique number that identifies on the
network a connection that supports a given inter-domain
TE link.  This is a more flexible alternative to specifying
'remote-te-node-id' and 'remote-te-link-tp-id' on a TE link
when the provider either does not know 'remote-te-node-id'
and 'remote-te-link-tp-id' or needs to give the client the
flexibility to mix and match multiple topologies.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBinary, is_leaf=True, yang_name="inter-domain-plug-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inter_domain_plug_id must be of a type compatible with binary""",
          'defined-type': "binary",
          'generated-type': """YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="inter-domain-plug-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)""",
        })

    self.__inter_domain_plug_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inter_domain_plug_id(self):
    self.__inter_domain_plug_id = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="inter-domain-plug-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)


  def _get_inter_layer_lock_id(self):
    """
    Getter method for inter_layer_lock_id, mapped from YANG variable /networks/network/node/termination_point/te/inter_layer_lock_id (uint32)

    YANG Description: Inter-layer lock ID, used for path computation in a TE
topology covering multiple layers or multiple regions.
    """
    return self.__inter_layer_lock_id
      
  def _set_inter_layer_lock_id(self, v, load=False):
    """
    Setter method for inter_layer_lock_id, mapped from YANG variable /networks/network/node/termination_point/te/inter_layer_lock_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inter_layer_lock_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inter_layer_lock_id() directly.

    YANG Description: Inter-layer lock ID, used for path computation in a TE
topology covering multiple layers or multiple regions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="inter-layer-lock-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inter_layer_lock_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="inter-layer-lock-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__inter_layer_lock_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inter_layer_lock_id(self):
    self.__inter_layer_lock_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="inter-layer-lock-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /networks/network/node/termination_point/te/oper_status (te-types:te-oper-status)

    YANG Description: The current operational state of the LTP.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /networks/network/node/termination_point/te/oper_status (te-types:te-oper-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with te-types:te-oper-status""",
          'defined-type': "te-types:te-oper-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)


  def _get_geolocation(self):
    """
    Getter method for geolocation, mapped from YANG variable /networks/network/node/termination_point/te/geolocation (container)

    YANG Description: Contains a GPS location.
    """
    return self.__geolocation
      
  def _set_geolocation(self, v, load=False):
    """
    Setter method for geolocation, mapped from YANG variable /networks/network/node/termination_point/te/geolocation (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_geolocation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_geolocation() directly.

    YANG Description: Contains a GPS location.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=geolocation.geolocation, is_container='container', yang_name="geolocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """geolocation must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=geolocation.geolocation, is_container='container', yang_name="geolocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__geolocation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_geolocation(self):
    self.__geolocation = YANGDynClass(base=geolocation.geolocation, is_container='container', yang_name="geolocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_otn_ltp(self):
    """
    Getter method for otn_ltp, mapped from YANG variable /networks/network/node/termination_point/te/otn_ltp (container)

    YANG Description: Attributes of the OTN Link Termination Point (LTP).
    """
    return self.__otn_ltp
      
  def _set_otn_ltp(self, v, load=False):
    """
    Setter method for otn_ltp, mapped from YANG variable /networks/network/node/termination_point/te/otn_ltp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn_ltp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn_ltp() directly.

    YANG Description: Attributes of the OTN Link Termination Point (LTP).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=otn_ltp.otn_ltp, is_container='container', yang_name="otn-ltp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn_ltp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=otn_ltp.otn_ltp, is_container='container', yang_name="otn-ltp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)""",
        })

    self.__otn_ltp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn_ltp(self):
    self.__otn_ltp = YANGDynClass(base=otn_ltp.otn_ltp, is_container='container', yang_name="otn-ltp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)


  def _get_client_svc(self):
    """
    Getter method for client_svc, mapped from YANG variable /networks/network/node/termination_point/te/client_svc (container)

    YANG Description: OTN LTP Service attributes.
    """
    return self.__client_svc
      
  def _set_client_svc(self, v, load=False):
    """
    Setter method for client_svc, mapped from YANG variable /networks/network/node/termination_point/te/client_svc (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_svc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_svc() directly.

    YANG Description: OTN LTP Service attributes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=client_svc.client_svc, is_container='container', yang_name="client-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_svc must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=client_svc.client_svc, is_container='container', yang_name="client-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)""",
        })

    self.__client_svc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_svc(self):
    self.__client_svc = YANGDynClass(base=client_svc.client_svc, is_container='container', yang_name="client-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)

  admin_status = __builtin__.property(_get_admin_status, _set_admin_status)
  name = __builtin__.property(_get_name, _set_name)
  interface_switching_capability = __builtin__.property(_get_interface_switching_capability, _set_interface_switching_capability)
  inter_domain_plug_id = __builtin__.property(_get_inter_domain_plug_id, _set_inter_domain_plug_id)
  inter_layer_lock_id = __builtin__.property(_get_inter_layer_lock_id, _set_inter_layer_lock_id)
  oper_status = __builtin__.property(_get_oper_status)
  geolocation = __builtin__.property(_get_geolocation)
  otn_ltp = __builtin__.property(_get_otn_ltp, _set_otn_ltp)
  client_svc = __builtin__.property(_get_client_svc, _set_client_svc)


  _pyangbind_elements = OrderedDict([('admin_status', admin_status), ('name', name), ('interface_switching_capability', interface_switching_capability), ('inter_domain_plug_id', inter_domain_plug_id), ('inter_layer_lock_id', inter_layer_lock_id), ('oper_status', oper_status), ('geolocation', geolocation), ('otn_ltp', otn_ltp), ('client_svc', client_svc), ])


