
import operator
from sqlalchemy import CheckConstraint, Column, DateTime, Float, ForeignKey, Integer, String ,Boolean
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.types import ARRAY
from sqlalchemy.orm import relationship
from typing import Dict
from ._Base import _Base

class OpticalLinkModel(_Base):
    __tablename__ = 'opticallink'

    optical_link_uuid           = Column(UUID(as_uuid=False), primary_key=True)
    optical_link_name           = Column(String, nullable=False)
    length = Column(Integer, nullable=True)
    source  = Column(String, nullable=True)
    target  = Column(String, nullable=True)
    optical_link_fiber= relationship("FiberModel") 
    created_at          = Column(DateTime, nullable=False)
    updated_at          = Column(DateTime, nullable=False)

 
   

    def dump_id(self) -> Dict:
        return {'optical_link_uuid': {'uuid': self.link_uuid}}

    def dump(self) -> Dict:
        result = {
            'optical_link_id'   : self.dump_id(),
            'name'              : self.optical_link_name,
            'details': {
                "length"        : self.length,
                'source'        : self.source,
                "target"        : self.target,
                'fibers'        : [ fiber.dump() for fiber in self.optical_link_fiber ]
            }
          
        }
       
        return result

class FiberModel(_Base):
    __tablename__ = 'fiber'
    fiber_uuid  = Column(UUID(as_uuid=False), primary_key=True)
    fiber_length = Column(Integer, nullable=True)
    source_port  = Column(String, nullable=True)
    destination_port  = Column(String, nullable=True)
    local_peer_port = Column(String, nullable=True)
    remote_peer_port = Column(String, nullable=True)
    used = Column(Boolean ,nullable=true)
    c_slots = Column (ARRAY(Integer),nullable=True)
    l_slots = Column (ARRAY(Integer),nullable=True)
    s_slots = Column (ARRAY(Integer),nullable=True)
    optical_link_uuid     = Column(ForeignKey('opticallink.optical_link_uuid',  ondelete='CASCADE' ), primary_key=True)
	optical_link     = relationship('OpticalLinkModel',     back_populates='optical_link_fibers')
 
 
 	def dump_id(self) -> Dict:
        return {'fiber_uuid': {'uuid': self.fiber_uuid}}
    
    
    def dump(self) -> Dict:
        result = {
        'ID'               : self.dump_id(),
        'length'           : self.fiber_length,
        "src_port"         : self.source_port,
        "dst_port"         : self.destination_port,
        "local_peer_port"  : self.local_peer_port,
        "remote_peer_port" : self.remote_peer_port,
        "used"             : self.used,
        "c_slots"          : self.c_slots ,
        "l_slots"          : self.l_slots,
        "s_slots"          : self.s_slots
          
        }
       
        return result