
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from ._Builder import get_uuid_from_string, get_uuid_random

def channel_get_uuid(
    channel_name :str , allow_random : bool = False
) -> str:
    

    if len(channel_name) > 0:
        return get_uuid_from_string(channel_name)
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('channel uuid', channel_name),
       
    ], extra_details=['Channel name is required to produce a channel UUID'])
