# Copyright 2022-2024 ETSI OSG/SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from kpi_value_writer.service.KpiValueWriter import KpiValueWriter
from common.tools.kafka.Variables import KafkaTopic
from kpi_manager.client.KpiManagerClient import KpiManagerClient
from kpi_manager.tests.test_messages import create_kpi_descriptor_request
from common.proto.kpi_manager_pb2 import KpiDescriptor
from kpi_value_writer.tests.test_messages import create_kpi_id_request

LOGGER = logging.getLogger(__name__)

def test_GetKpiDescriptor():
    LOGGER.info(" >>> test_GetKpiDescriptor: START <<< ")
    kpi_manager_client = KpiManagerClient()
    # adding KPI
    LOGGER.info(" --->>> calling SetKpiDescriptor ")
    response_id = kpi_manager_client.SetKpiDescriptor(create_kpi_descriptor_request())
    # get KPI
    LOGGER.info(" --->>> calling GetKpiDescriptor with response ID")
    response = kpi_manager_client.GetKpiDescriptor(response_id)
    LOGGER.info("Response gRPC message object: {:}".format(response))
    
    LOGGER.info(" --->>> calling GetKpiDescriptor with random ID")
    rand_response = kpi_manager_client.GetKpiDescriptor(create_kpi_id_request())
    LOGGER.info("Response gRPC message object: {:}".format(rand_response))

    LOGGER.info("\n------------------ TEST FINISHED ---------------------\n")
    assert isinstance(response, KpiDescriptor)

# -------- Initial Test ----------------
# def test_validate_kafka_topics():
#     LOGGER.debug(" >>> test_validate_kafka_topics: START <<< ")
#     response = KafkaTopic.create_all_topics()
#     assert isinstance(response, bool)

# def test_KafkaConsumer():
#     LOGGER.debug(" --->>> test_kafka_consumer: START <<<--- ")
#     KpiValueWriter.RunKafkaConsumer()

