# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import label_restrictions
from . import underlay
from . import path_constraints
from . import optimizations
from . import path_properties
from . import connectivity_matrix
class connectivity_matrices(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains a connectivity matrix on a TE node.
  """
  __slots__ = ('_path_helper', '_extmethods', '__number_of_entries','__label_restrictions','__is_allowed','__underlay','__path_constraints','__optimizations','__path_properties','__connectivity_matrix',)

  _yang_name = 'connectivity-matrices'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__number_of_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__is_allowed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_constraints = YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__optimizations = YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_properties = YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__connectivity_matrix = YANGDynClass(base=YANGListType("id",connectivity_matrix.connectivity_matrix, yang_name="connectivity-matrix", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="connectivity-matrix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices']

  def _get_number_of_entries(self):
    """
    Getter method for number_of_entries, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/number_of_entries (uint16)

    YANG Description: The number of connectivity matrix entries.
If this number is specified in the configuration request,
the number is the requested number of entries, which may
not all be listed in the list;
if this number is reported in the state data,
the number is the current number of operational entries.
    """
    return self.__number_of_entries
      
  def _set_number_of_entries(self, v, load=False):
    """
    Setter method for number_of_entries, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/number_of_entries (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_number_of_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_number_of_entries() directly.

    YANG Description: The number of connectivity matrix entries.
If this number is specified in the configuration request,
the number is the requested number of entries, which may
not all be listed in the list;
if this number is reported in the state data,
the number is the current number of operational entries.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """number_of_entries must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)""",
        })

    self.__number_of_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_number_of_entries(self):
    self.__number_of_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)


  def _get_label_restrictions(self):
    """
    Getter method for label_restrictions, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions (container)

    YANG Description: The label restrictions container.
    """
    return self.__label_restrictions
      
  def _set_label_restrictions(self, v, load=False):
    """
    Setter method for label_restrictions, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_restrictions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_restrictions() directly.

    YANG Description: The label restrictions container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_restrictions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__label_restrictions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_restrictions(self):
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_is_allowed(self):
    """
    Getter method for is_allowed, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/is_allowed (boolean)

    YANG Description: 'true' - switching is allowed;
'false' - switching is disallowed.
    """
    return self.__is_allowed
      
  def _set_is_allowed(self, v, load=False):
    """
    Setter method for is_allowed, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/is_allowed (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_is_allowed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_is_allowed() directly.

    YANG Description: 'true' - switching is allowed;
'false' - switching is disallowed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """is_allowed must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)""",
        })

    self.__is_allowed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_is_allowed(self):
    self.__is_allowed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)


  def _get_underlay(self):
    """
    Getter method for underlay, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/underlay (container)

    YANG Description: Attributes of the TE link underlay.
    """
    return self.__underlay
      
  def _set_underlay(self, v, load=False):
    """
    Setter method for underlay, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/underlay (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_underlay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_underlay() directly.

    YANG Description: Attributes of the TE link underlay.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """underlay must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__underlay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_underlay(self):
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_constraints(self):
    """
    Getter method for path_constraints, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/path_constraints (container)

    YANG Description: TE named path constraints container.
    """
    return self.__path_constraints
      
  def _set_path_constraints(self, v, load=False):
    """
    Setter method for path_constraints, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/path_constraints (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_constraints is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_constraints() directly.

    YANG Description: TE named path constraints container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_constraints must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_constraints = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_constraints(self):
    self.__path_constraints = YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_optimizations(self):
    """
    Getter method for optimizations, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/optimizations (container)

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    return self.__optimizations
      
  def _set_optimizations(self, v, load=False):
    """
    Setter method for optimizations, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/optimizations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optimizations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optimizations() directly.

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optimizations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__optimizations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optimizations(self):
    self.__optimizations = YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_properties(self):
    """
    Getter method for path_properties, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/path_properties (container)

    YANG Description: The TE path properties.
    """
    return self.__path_properties
      
  def _set_path_properties(self, v, load=False):
    """
    Setter method for path_properties, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/path_properties (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_properties is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_properties() directly.

    YANG Description: The TE path properties.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_properties must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_properties = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_properties(self):
    self.__path_properties = YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_connectivity_matrix(self):
    """
    Getter method for connectivity_matrix, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix (list)

    YANG Description: Represents a node's switching limitations, i.e.,
limitations in the interconnecting network TE links
across the node.
    """
    return self.__connectivity_matrix
      
  def _set_connectivity_matrix(self, v, load=False):
    """
    Setter method for connectivity_matrix, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connectivity_matrix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connectivity_matrix() directly.

    YANG Description: Represents a node's switching limitations, i.e.,
limitations in the interconnecting network TE links
across the node.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",connectivity_matrix.connectivity_matrix, yang_name="connectivity-matrix", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="connectivity-matrix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connectivity_matrix must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",connectivity_matrix.connectivity_matrix, yang_name="connectivity-matrix", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="connectivity-matrix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__connectivity_matrix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connectivity_matrix(self):
    self.__connectivity_matrix = YANGDynClass(base=YANGListType("id",connectivity_matrix.connectivity_matrix, yang_name="connectivity-matrix", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="connectivity-matrix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

  number_of_entries = __builtin__.property(_get_number_of_entries)
  label_restrictions = __builtin__.property(_get_label_restrictions)
  is_allowed = __builtin__.property(_get_is_allowed)
  underlay = __builtin__.property(_get_underlay)
  path_constraints = __builtin__.property(_get_path_constraints)
  optimizations = __builtin__.property(_get_optimizations)
  path_properties = __builtin__.property(_get_path_properties)
  connectivity_matrix = __builtin__.property(_get_connectivity_matrix)


  _pyangbind_elements = OrderedDict([('number_of_entries', number_of_entries), ('label_restrictions', label_restrictions), ('is_allowed', is_allowed), ('underlay', underlay), ('path_constraints', path_constraints), ('optimizations', optimizations), ('path_properties', path_properties), ('connectivity_matrix', connectivity_matrix), ])


