# 3.X. Developing a new component: Forecaster (WORK IN PROGRESS)


## 3.X.1. Preliminary requisites
As any microservice-based architecture, the components of TeraFlowSDN can be implemented using different programming languages.
For the sake of simplicity, and given it is the most widely used programming language in TeraFlow, this tutorial page assumes the reader will use Python.

This tutorial assumes you hace successfully completed the steps in
[2.1. Configure the Python Environment](./2-1-python-environment.md) and
[3.1. Configure VSCode and Connect to the VM](./3-1-configure-vscode.md) to prepare your environment.


## 3.X.2. Create the component folder structure
The source code of each component of TeraFlowSDN is hosted in a particular folder within the `src` folder.
Within that folder, typically, 3 subfolders are created:
- Folder `client`: contains a client implementation that the rest of components can use to interact with the component.
  See details in [3.X.4. Create the component client](./3-X-develop-new-component.md#3x4-create-the-component-client).
- Folder `service`: contains the implementation of the service logic.
  See details in [3.X.5. Create the component service](./3-X-develop-new-component.md#3x5-create-the-component-service).
- Folder `tests`: contains the set of unitary tests to be executed over the component to ensure it is properly implemented.
  See details in [3.X.6. Create the component tests](./3-X-develop-new-component.md#3x6-create-the-component-tests).
- File `__init__.py`: defines the component as a sub-package of TeraFlowSDN to facilitate imports.
- File `.gitlab-ci.yml`: defines the GitLab CI/CD settings to build, test, and deploy the component in an automated manner.
- File `Config.py`: contains particular configuration settings and constants for the component.
- File `Dockerfile`: defines the recipe to construct the Docker image for the component.
- File `requirements.in`: defines the Python dependencies that are required by this component.

You can automate the creation of this file structure running the following command.
In this example, we create the `forecaster` component.
```bash
cd ~/tfs-ctrl
scripts/create_component.sh forecaster
```


## 3.X.3. gRPC Proto messages and services
The components, e.g., microservices, of the TeraFlowSDN controller, in general, use a gRPC-based open API to interoperate.
All the protocol definitions can be found in sub-folder `proto` within the root project folder.
For additional details on gRPC, visit the official web-page [gRPC](https://grpc.io/).

In general, each component has an associated _proto_ file named as the name of the component in snake_case.proto.
For instance, the _proto_ file for the `forecaster` component being developed in this tutorial is `proto/forecaster.proto` and implements 3 RPC methods:
- `rpc GetForecastOfTopology (context.TopologyId) returns (Forecast) {}´:
  Takes a topology identifier as parameter, and computes the aggregated forecast for the topology.
- `rpc GetForecastOfLink(context.LinkId) returns (Forecast) {}´:
  Takes a link identifier as parameter, and computes the aggregated forecast for that link.
- `rpc CheckService (context.ServiceId) returns (ForecastPrediction) {}´:
  Takes a service identifier as parameter, computes the forecast for the connections of that service, and retrieves a value indicating if the resources can support the demand.


## 3.X.4. Create the component client
Each component has, by default, a pre-defined client that other components can import to inter-communicate.
The client module, by default, is named as the component's name concatenated with `client`, and written in CamelCase.
For instance, the client for the `forecaster` component would be `ForecasterClient.py`.

This file contains a class with the same name as the file, e.g., `ForecasterClient`, and implements 3 main methods, plus one method for each RPC method supported by the service. These methods are:
- Main methods:
  - `__init__(host=None, port=None)`: constructor of the client class.
  - `connect(self)`: triggers the connection of the client to the service pointed by host and port class parameters.
  - `close(self)`: disconnects the client from the service.
- RPC methods: one for each RPC method defined in the associated service within the proto file, e.g., `proto/forecaster.proto`.

Create file `` 



## 3.X.3. Connect VSCode to the VM through "Remote SSH" extension
- Right-click on "TFS-VM"
- Select "Connect to Host in Current Window"
- Reply to the questions asked
  - Platform of the remote host "TFS-VM": Linux
  - "TFS-VM" has fingerprint "<fingerprint>". Do you want to continue?: Continue
  - Type tfs user's password: tfs123
- You should be now connected to the TFS-VM.

__Note__: if you get a connection error message, the reason might be due to wrong SSH server fingerprint. Edit file
          "<...>/.ssh/known_hosts" on your local user account, check if there is a line starting with
          "[127.0.0.1]:2200" (assuming previous port forwarding configuration), remove the entire line, save the file,
          and retry connection.


## 3.X.4. Add SSH key to prevent typing the password every time
This step creates an SSH key in the VM and installs it on the VSCode to prevent having to type the password every time.

- In VSCode (connected to the VM), click menu "Terminal > New Terminal"
- Run the following commands on the VM's terminal through VSCode
```bash
ssh-keygen -t rsa -b 4096 -f ~/.ssh/tfs-vm.key
  # leave password empty
ssh-copy-id -i ~/.ssh/tfs-vm.key.pub tfs@10.0.2.10
  # tfs@10.0.2.10's password: <type tfs user's password: tfs123>
rm .ssh/known_hosts 
```

- In VSCode, click left "Explorer" panel to expand, if not expanded, and click "Open Folder" button.
  - Choose "/home/tfs/"
  - Type tfs user's password when asked
  - Trust authors of the "/home/tfs [SSH: TFS-VM]" folder when asked
- Right click on the file "tfs-vm.key" in the file explorer
  - Select "Download..." option
  - Download the file into your user's accout ".ssh" folder
- Delete files "tfs-vm.key" and "tfs-vm.key.pub" on the TFS-VM.

- In VSCode, click left "Remote Explorer" panel to expand
  - Click the "gear" icon next to "SSH TARGETS" on top of "Remote Explorer" bar
  - Choose to edit "<...>/.ssh/config" file (or equivalent)
  - Find entry "Host TFS-VM" and update it as follows:
```
Host TFS-VM
    HostName 127.0.0.1
    Port 2200
    ForwardX11 no
    User tfs
    IdentityFile "<path to the downloaded identity private key file>"
```
  - Save the file
- From now, VSCode will use the identity file to connect to the TFS-VM instead of the user's password.


## 3.X.5. Install VSCode Python Extension (in VSCode server)
This step installs Python extensions in VSCode server running in the VM.

- In VSCode (connected to the VM), click left button "Extensions"
- Search "Python" extension in the extension Marketplace.
- Install official "Python" extension released by Microsoft.
  - By default, since you're connected to the VM, it will be installed in the VSCode server running in the VM.

- In VSCode (connected to the VM), click left button "Explorer"
- Click "Ctrl+Alt+P" and type "Python: Select Interpreter". Select option "Python: 3.9.13 64-bit ('tfs')"

in terminal: set python path to be used by VSCode:
`echo "PYTHONPATH=./src" > ~/tfs-ctrl/.env`
