import logging
from werkzeug.security import generate_password_hash

# General settings
LOG_LEVEL = logging.WARNING

# gRPC settings
GRPC_SERVICE_PORT = 9090
GRPC_MAX_WORKERS  = 10
GRPC_GRACE_PERIOD = 60

# REST-API settings
RESTAPI_SERVICE_PORT = 8080
RESTAPI_BASE_URL = '/restconf/data'
RESTAPI_USERS = {   # TODO: implement a database of credentials and permissions
    'admin': generate_password_hash('admin'),
}

# Prometheus settings
METRICS_PORT = 9192
