import logging
from typing import Optional, Union
from ._engine._Database import _Database
from ._engine.Factory import BackendEnum, get_database_backend
from ._engine.object.Collection import Collection
from .objects._Keys import KEY_CONTEXTS
from .objects.Context import Context

LOGGER = logging.getLogger(__name__)

class Database(_Database):
    def __init__(self, backend : Optional[Union[str, BackendEnum]] = None, **settings):
        super().__init__(get_database_backend(backend=backend, **settings))
        self._contexts = Collection(self, KEY_CONTEXTS)

    @property
    def parent(self) -> 'Database': return self

    @property
    def contexts(self) -> Collection: return self._contexts

    def context(self, context_uuid : str) -> Context: return Context(context_uuid, self)
