from enum import Enum

class DeviceOperationalStatus(Enum):
    UNDEFINED = 0
    DISABLED = 1
    ENABLED = 2

ANY_TO_ENUM = {
    0: DeviceOperationalStatus.UNDEFINED,
    1: DeviceOperationalStatus.DISABLED,
    2: DeviceOperationalStatus.ENABLED,

    '0': DeviceOperationalStatus.UNDEFINED,
    '1': DeviceOperationalStatus.DISABLED,
    '2': DeviceOperationalStatus.ENABLED,

    'UNDEFINED': DeviceOperationalStatus.UNDEFINED,
    'DISABLED': DeviceOperationalStatus.DISABLED,
    'ENABLED': DeviceOperationalStatus.ENABLED,
}

def deviceoperationalstatus_enum_values():
    return {m.value for m in DeviceOperationalStatus.__members__.values()}

def to_deviceoperationalstatus_enum(int_or_str):
    if isinstance(int_or_str, str): int_or_str = int_or_str.upper()
    return ANY_TO_ENUM.get(int_or_str)
