import copy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from context.proto.context_pb2 import (
    ConfigActionEnum, DeviceDriverEnum, DeviceOperationalStatusEnum, ServiceStatusEnum, ServiceTypeEnum)

# Some example objects to be used by the tests

## use "copy.deepcopy" to prevent propagating forced changes during tests
CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {'context_id': copy.deepcopy(CONTEXT_ID)}

TOPOLOGY_ID = {
    'context_id': copy.deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': copy.deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}

DEVICE1_UUID = 'DEV1'
DEVICE1_ID = {'device_uuid': {'uuid': DEVICE1_UUID}}
DEVICE1 = {
    'device_id': copy.deepcopy(DEVICE1_ID),
    'device_type': 'packet-router',
    'device_config': {'config_rules': [
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-1/value',
         'resource_value': 'value1'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-2/value',
         'resource_value': 'value2'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-3/value',
         'resource_value': 'value3'},
    ]},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG, DeviceDriverEnum.DEVICEDRIVER_P4],
    'device_endpoints': [
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE1_ID),
            'endpoint_uuid': {'uuid': 'EP1'},
        }, 'endpoint_type': 'port-packet-100G'},
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE1_ID),
            'endpoint_uuid': {'uuid': 'EP2'},
        }, 'endpoint_type': 'port-packet-100G'},
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE1_ID),
            'endpoint_uuid': {'uuid': 'EP3'},
        }, 'endpoint_type': 'port-packet-100G'},
    ],
}

DEVICE2_UUID = 'DEV2'
DEVICE2_ID = {'device_uuid': {'uuid': DEVICE2_UUID}}
DEVICE2 = {
    'device_id': copy.deepcopy(DEVICE2_ID),
    'device_type': 'packet-router',
    'device_config': {'config_rules': [
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-1/value',
         'resource_value': 'value4'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-2/value',
         'resource_value': 'value5'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'device/resource-3/value',
         'resource_value': 'value6'},
    ]},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG, DeviceDriverEnum.DEVICEDRIVER_P4],
    'device_endpoints': [
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE2_ID),
            'endpoint_uuid': {'uuid': 'EP1'},
        }, 'endpoint_type': 'port-packet-100G'},
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE2_ID),
            'endpoint_uuid': {'uuid': 'EP2'},
        }, 'endpoint_type': 'port-packet-100G'},
        {'endpoint_id': {
            'topology_id': copy.deepcopy(TOPOLOGY_ID),
            'device_id': copy.deepcopy(DEVICE2_ID),
            'endpoint_uuid': {'uuid': 'EP3'},
        }, 'endpoint_type': 'port-packet-100G'},
    ],
}

LINK_UUID = 'DEV1/EP2 ==> DEV2/EP1'
LINK_ID = {'link_uuid': {'uuid': LINK_UUID}}
LINK = {
    'link_id': copy.deepcopy(LINK_ID),
    'link_endpoint_ids' : [
        {'topology_id': copy.deepcopy(TOPOLOGY_ID),
         'device_id': copy.deepcopy(DEVICE1_ID),
         'endpoint_uuid': {'uuid' : 'EP2'}},
        {'topology_id': copy.deepcopy(TOPOLOGY_ID),
         'device_id': copy.deepcopy(DEVICE2_ID),
         'endpoint_uuid': {'uuid' : 'EP1'}},
    ]
}

SERVICE_UUID = 'SVC:DEV1/EP2-DEV2/EP1'
SERVICE_ID = {
    'context_id': copy.deepcopy(CONTEXT_ID),
    'service_uuid': {'uuid': SERVICE_UUID},
}
SERVICE = {
    'service_id': copy.deepcopy(SERVICE_ID),
    'service_type': ServiceTypeEnum.SERVICETYPE_L3NM,
    'service_endpoint_ids' : [
        {'topology_id': copy.deepcopy(TOPOLOGY_ID),
         'device_id': copy.deepcopy(DEVICE1_ID),
         'endpoint_uuid': {'uuid' : 'EP2'}},
        {'topology_id': copy.deepcopy(TOPOLOGY_ID),
         'device_id': copy.deepcopy(DEVICE2_ID),
         'endpoint_uuid': {'uuid' : 'EP1'}},
    ],
    'service_constraints': [
        {'constraint_type': 'latency_ms', 'constraint_value': '15.2'},
        {'constraint_type': 'jitter_us', 'constraint_value': '1.2'},
    ],
    'service_status': {'service_status': ServiceStatusEnum.SERVICESTATUS_ACTIVE},
    'service_config': {'config_rules': [
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'service/resource-1/value',
         'resource_value': 'value7'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'service/resource-2/value',
         'resource_value': 'value8'},
        {'action': ConfigActionEnum.CONFIGACTION_SET,
         'resource_key': 'service/resource-3/value',
         'resource_value': 'value9'},
    ]},
}
