# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import datetime

from common.proto import monitoring_pb2
from common.proto.kpi_sample_types_pb2 import KpiSampleType
from common.tools.timestamp.Converters import timestamp_string_to_float, timestamp_utcnow_to_float


def kpi_id():
    _kpi_id             = monitoring_pb2.KpiId()
    _kpi_id.kpi_id.uuid = str(1)            # pylint: disable=maybe-no-member
    return _kpi_id

def create_kpi_request():
    _create_kpi_request                                = monitoring_pb2.KpiDescriptor()
    _create_kpi_request.kpi_description                = 'KPI Description Test'
    _create_kpi_request.kpi_sample_type                = KpiSampleType.KPISAMPLETYPE_PACKETS_TRANSMITTED
    _create_kpi_request.device_id.device_uuid.uuid     = 'DEV1'     # pylint: disable=maybe-no-member
    _create_kpi_request.service_id.service_uuid.uuid   = 'SERV1'    # pylint: disable=maybe-no-member
    _create_kpi_request.endpoint_id.endpoint_uuid.uuid = 'END1'     # pylint: disable=maybe-no-member
    return _create_kpi_request

def create_kpi_request_b():
    _create_kpi_request                                = monitoring_pb2.KpiDescriptor()
    _create_kpi_request.kpi_description                = 'KPI Description Test'
    _create_kpi_request.kpi_sample_type                = KpiSampleType.KPISAMPLETYPE_PACKETS_RECEIVED
    _create_kpi_request.device_id.device_uuid.uuid     = 'DEV2'     # pylint: disable=maybe-no-member
    _create_kpi_request.service_id.service_uuid.uuid   = 'SERV2'    # pylint: disable=maybe-no-member
    _create_kpi_request.endpoint_id.endpoint_uuid.uuid = 'END2'     # pylint: disable=maybe-no-member
    return _create_kpi_request

def create_kpi_request_c():
    _create_kpi_request                                = monitoring_pb2.KpiDescriptor()
    _create_kpi_request.kpi_description                = 'KPI Description Test'
    _create_kpi_request.kpi_sample_type                = KpiSampleType.KPISAMPLETYPE_PACKETS_RECEIVED
    _create_kpi_request.device_id.device_uuid.uuid     = 'DEV3'     # pylint: disable=maybe-no-member
    _create_kpi_request.service_id.service_uuid.uuid   = 'SERV3'    # pylint: disable=maybe-no-member
    _create_kpi_request.endpoint_id.endpoint_uuid.uuid = 'END3'     # pylint: disable=maybe-no-member
    return _create_kpi_request

def monitor_kpi_request(kpi_uuid, monitoring_window_s, sampling_rate_s):
    _monitor_kpi_request                     = monitoring_pb2.MonitorKpiRequest()
    _monitor_kpi_request.kpi_id.kpi_id.uuid  = kpi_uuid   # pylint: disable=maybe-no-member
    _monitor_kpi_request.monitoring_window_s = monitoring_window_s
    _monitor_kpi_request.sampling_rate_s     = sampling_rate_s
    return _monitor_kpi_request

def include_kpi_request(kpi_id):
    _include_kpi_request                        = monitoring_pb2.Kpi()
    _include_kpi_request.kpi_id.kpi_id.uuid     = kpi_id.kpi_id.uuid
    _include_kpi_request.timestamp.timestamp    = timestamp_utcnow_to_float()
    _include_kpi_request.kpi_value.int32Val     = 500       # pylint: disable=maybe-no-member
    return _include_kpi_request

def kpi_descriptor_list():
    _kpi_descriptor_list = monitoring_pb2.KpiDescriptorList()

    return _kpi_descriptor_list

def kpi_query():
    _kpi_query = monitoring_pb2.KpiQuery()

    return _kpi_query

def subs_descriptor():
    _subs_descriptor = monitoring_pb2.SubsDescriptor()

    return _subs_descriptor

def subs_id():
    _subs_id = monitoring_pb2.SubsDescriptor()

    return _subs_id

def alarm_descriptor():
    _alarm_descriptor = monitoring_pb2.AlarmDescriptor()

    return _alarm_descriptor

def alarm_id():
    _alarm_id = monitoring_pb2.AlarmID()

    return _alarm_id