# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import uuid
import random
from common.proto import telemetry_frontend_pb2
from common.proto.kpi_sample_types_pb2 import KpiSampleType


# ----------------------- "2nd" Iteration --------------------------------
def create_collector_id():
    _collector_id                   = telemetry_frontend_pb2.CollectorId()
    _collector_id.collector_id.uuid = uuid.uuid4()
    return _collector_id

# def create_collector_id_a(coll_id_str : str):
#     _collector_id                   = telemetry_frontend_pb2.CollectorId()
#     _collector_id.collector_id.uuid = str(coll_id_str)
#     return _collector_id

def create_collector_request():
    _create_collector_request                                = telemetry_frontend_pb2.Collector()
    _create_collector_request.collector_id.collector_id.uuid = str(uuid.uuid4())
    _create_collector_request.kpi_id.kpi_id.uuid             = "165d20c5-a446-42fa-812f-e2b7ed283c6f"
    # _create_collector_request.collector                      = "collector description"
    _create_collector_request.duration_s                     = float(random.randint(8, 16))
    _create_collector_request.interval_s                     = float(random.randint(2, 4))
    return _create_collector_request

def create_collector_filter():
    _create_collector_filter = telemetry_frontend_pb2.CollectorFilter()
    new_kpi_id               = _create_collector_filter.kpi_id.add()
    new_kpi_id.kpi_id.uuid   = "165d20c5-a446-42fa-812f-e2b7ed283c6f"
    return _create_collector_filter

# ----------------------- "First" Iteration --------------------------------
# def create_collector_request_a():
#     _create_collector_request_a                                = telemetry_frontend_pb2.Collector()
#     _create_collector_request_a.collector_id.collector_id.uuid = "-1"
#     return _create_collector_request_a

# def create_collector_request_b(str_kpi_id, coll_duration_s, coll_interval_s
#                                ) -> telemetry_frontend_pb2.Collector:
#     _create_collector_request_b                                = telemetry_frontend_pb2.Collector()
#     _create_collector_request_b.collector_id.collector_id.uuid = '1'
#     _create_collector_request_b.kpi_id.kpi_id.uuid             = str_kpi_id
#     _create_collector_request_b.duration_s                     = coll_duration_s
#     _create_collector_request_b.interval_s                     = coll_interval_s
#     return _create_collector_request_b

# def create_collector_filter():
#     _create_collector_filter = telemetry_frontend_pb2.CollectorFilter()
#     new_collector_id                       = _create_collector_filter.collector_id.add()
#     new_collector_id.collector_id.uuid     = "COLL1"
#     new_kpi_id                             = _create_collector_filter.kpi_id.add()
#     new_kpi_id.kpi_id.uuid                 = "KPI1"
#     new_device_id                          = _create_collector_filter.device_id.add()
#     new_device_id.device_uuid.uuid         = 'DEV1'
#     new_service_id                         = _create_collector_filter.service_id.add()
#     new_service_id.service_uuid.uuid       = 'SERV1'
#     new_slice_id                           = _create_collector_filter.slice_id.add()
#     new_slice_id.slice_uuid.uuid           = 'SLC1'
#     new_endpoint_id                        = _create_collector_filter.endpoint_id.add()
#     new_endpoint_id.endpoint_uuid.uuid     = 'END1'
#     new_connection_id                      = _create_collector_filter.connection_id.add()
#     new_connection_id.connection_uuid.uuid = 'CON1'
#     _create_collector_filter.kpi_sample_type.append(KpiSampleType.KPISAMPLETYPE_PACKETS_RECEIVED)
#     return _create_collector_filter

# def create_collector_list():
#     _create_collector_list = telemetry_frontend_pb2.CollectorList()
#     return _create_collector_list