# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import tunnel_termination_point
from . import local_link_connectivity
class statistics(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/statistics. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Statistics data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__discontinuity_time','__tunnel_termination_point','__local_link_connectivity',)

  _yang_name = 'statistics'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    self.__tunnel_termination_point = YANGDynClass(base=tunnel_termination_point.tunnel_termination_point, is_container='container', yang_name="tunnel-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__local_link_connectivity = YANGDynClass(base=local_link_connectivity.local_link_connectivity, is_container='container', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'statistics']

  def _get_discontinuity_time(self):
    """
    Getter method for discontinuity_time, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/discontinuity_time (yang:date-and-time)

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    return self.__discontinuity_time
      
  def _set_discontinuity_time(self, v, load=False):
    """
    Setter method for discontinuity_time, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/discontinuity_time (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_discontinuity_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_discontinuity_time() directly.

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """discontinuity_time must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__discontinuity_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_discontinuity_time(self):
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)


  def _get_tunnel_termination_point(self):
    """
    Getter method for tunnel_termination_point, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point (container)

    YANG Description: Contains statistics attributes at the TE TTP level.
    """
    return self.__tunnel_termination_point
      
  def _set_tunnel_termination_point(self, v, load=False):
    """
    Setter method for tunnel_termination_point, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/tunnel_termination_point (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tunnel_termination_point is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tunnel_termination_point() directly.

    YANG Description: Contains statistics attributes at the TE TTP level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=tunnel_termination_point.tunnel_termination_point, is_container='container', yang_name="tunnel-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tunnel_termination_point must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=tunnel_termination_point.tunnel_termination_point, is_container='container', yang_name="tunnel-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__tunnel_termination_point = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tunnel_termination_point(self):
    self.__tunnel_termination_point = YANGDynClass(base=tunnel_termination_point.tunnel_termination_point, is_container='container', yang_name="tunnel-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_local_link_connectivity(self):
    """
    Getter method for local_link_connectivity, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/local_link_connectivity (container)

    YANG Description: Contains statistics attributes at the TE LLCL (Local Link
Connectivity List) level.
    """
    return self.__local_link_connectivity
      
  def _set_local_link_connectivity(self, v, load=False):
    """
    Setter method for local_link_connectivity, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/statistics/local_link_connectivity (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_link_connectivity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_link_connectivity() directly.

    YANG Description: Contains statistics attributes at the TE LLCL (Local Link
Connectivity List) level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=local_link_connectivity.local_link_connectivity, is_container='container', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_link_connectivity must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=local_link_connectivity.local_link_connectivity, is_container='container', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__local_link_connectivity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_link_connectivity(self):
    self.__local_link_connectivity = YANGDynClass(base=local_link_connectivity.local_link_connectivity, is_container='container', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  discontinuity_time = __builtin__.property(_get_discontinuity_time)
  tunnel_termination_point = __builtin__.property(_get_tunnel_termination_point)
  local_link_connectivity = __builtin__.property(_get_local_link_connectivity)


  _pyangbind_elements = OrderedDict([('discontinuity_time', discontinuity_time), ('tunnel_termination_point', tunnel_termination_point), ('local_link_connectivity', local_link_connectivity), ])


