/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.data.DataPoint;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Polygon;
import jcckit.graphic.Text;
import jcckit.plot.AxisParameters;
import jcckit.plot.CoordinateSystem;
import jcckit.transformation.CartesianTransformation;
import jcckit.transformation.Transformation;
import jcckit.util.ConfigParameters;

public class CartesianCoordinateSystem
implements CoordinateSystem {
    public static final String ORIGIN_KEY = "origin";
    public static final String X_AXIS_KEY = "xAxis";
    public static final String Y_AXIS_KEY = "yAxis";
    private final CartesianTransformation _transformation;
    private final GraphicalComposite _view;
    private final ClippingRectangle _clippingRectangle;

    public CartesianCoordinateSystem(ConfigParameters configParameters) {
        this(new GraphPoint(configParameters.getDoubleArray(ORIGIN_KEY, new double[]{0.15, 0.1})), AxisParameters.createXAxis(configParameters.getNode(X_AXIS_KEY)), AxisParameters.createYAxis(configParameters.getNode(Y_AXIS_KEY)));
    }

    public CartesianCoordinateSystem(GraphPoint graphPoint, AxisParameters axisParameters, AxisParameters axisParameters2) {
        double d = graphPoint.getX();
        double d2 = graphPoint.getY();
        this._transformation = new CartesianTransformation(axisParameters.logScale, axisParameters2.logScale, new DataPoint(axisParameters.minimum, axisParameters2.minimum), new GraphPoint(d, d2), new DataPoint(axisParameters.maximum, axisParameters2.maximum), new GraphPoint(d + axisParameters.axisLength, d2 + axisParameters2.axisLength));
        this._clippingRectangle = new ClippingRectangle(d, d2, d + axisParameters.axisLength, d2 + axisParameters2.axisLength);
        this._view = new GraphicalComposite(null);
        this.createView(graphPoint, axisParameters, axisParameters2);
    }

    private void createView(GraphPoint graphPoint, AxisParameters axisParameters, AxisParameters axisParameters2) {
        double d = graphPoint.getX();
        double d2 = d + axisParameters.axisLength;
        double d3 = graphPoint.getY();
        double d4 = d3 + axisParameters2.axisLength;
        GraphPoint graphPoint2 = new GraphPoint(d, d3);
        GraphPoint graphPoint3 = new GraphPoint(d, d4);
        GraphPoint graphPoint4 = new GraphPoint(d2, d3);
        GraphPoint graphPoint5 = new GraphPoint(d2, d4);
        LineAttributes lineAttributes = axisParameters.axisAttributes;
        LineAttributes lineAttributes2 = axisParameters2.axisAttributes;
        this.createTicsAndGrid(true, d3, d4, axisParameters);
        this.createTicsAndGrid(false, d, d2, axisParameters2);
        this.addLine(graphPoint2, graphPoint4, lineAttributes);
        this.addLine(graphPoint2, graphPoint3, lineAttributes2);
        this.addLine(graphPoint3, graphPoint5, lineAttributes);
        this.addLine(graphPoint4, graphPoint5, lineAttributes2);
        this.createLabel(0.5 * (d + d2), d3, axisParameters);
        this.createLabel(d, 0.5 * (d3 + d4), axisParameters2);
    }

    private void createLabel(double d, double d2, AxisParameters axisParameters) {
        if (axisParameters.axisLabel.length() > 0) {
            this._view.addElement(new Text(new GraphPoint(d + axisParameters.axisLabelPosition.getX(), d2 + axisParameters.axisLabelPosition.getY()), axisParameters.axisLabel, axisParameters.axisLabelAttributes));
        }
    }

    private void createTicsAndGrid(boolean bl, double d, double d2, AxisParameters axisParameters) {
        double[] dArray = axisParameters.calculateTics();
        int n = bl ? 1 : 0;
        double[] dArray2 = new double[2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[1 - n] = dArray[i];
            dArray2[n] = 1.0;
            GraphPoint graphPoint = this._transformation.transformToGraph(new DataPoint(dArray2[0], dArray2[1]));
            dArray2[0] = graphPoint.getX();
            dArray2[1] = graphPoint.getY();
            dArray2[n] = d2;
            graphPoint = new GraphPoint(dArray2[0], dArray2[1]);
            int n2 = n;
            dArray2[n2] = dArray2[n2] + axisParameters.ticLength;
            this.addLine(graphPoint, new GraphPoint(dArray2[0], dArray2[1]), axisParameters.ticAttributes);
            dArray2[n] = d;
            GraphPoint graphPoint2 = new GraphPoint(dArray2[0], dArray2[1]);
            if (axisParameters.grid) {
                this.addLine(graphPoint, graphPoint2, axisParameters.gridAttributes);
            }
            int n3 = n;
            dArray2[n3] = dArray2[n3] - axisParameters.ticLength;
            this.addLine(graphPoint2, new GraphPoint(dArray2[0], dArray2[1]), axisParameters.ticAttributes);
            if (axisParameters.ticLabelFormat == null) continue;
            int n4 = n;
            dArray2[n4] = dArray2[n4] + axisParameters.ticLength;
            dArray2[0] = dArray2[0] + axisParameters.ticLabelPosition.getX();
            dArray2[1] = dArray2[1] + axisParameters.ticLabelPosition.getY();
            this._view.addElement(new Text(new GraphPoint(dArray2[0], dArray2[1]), axisParameters.ticLabelFormat.form(dArray[i]), axisParameters.ticLabelAttributes));
        }
    }

    private void addLine(GraphPoint graphPoint, GraphPoint graphPoint2, GraphicAttributes graphicAttributes) {
        Polygon polygon = new Polygon(graphicAttributes, false);
        polygon.addPoint(graphPoint);
        polygon.addPoint(graphPoint2);
        this._view.addElement(polygon);
    }

    public GraphicalElement getView() {
        return this._view;
    }

    public ClippingShape getClippingShape() {
        return this._clippingRectangle;
    }

    public Transformation getTransformation() {
        return this._transformation;
    }
}

