# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import otn
class te_bandwidth(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/information-source-entry/unreserved-bandwidth/te-bandwidth. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container that specifies TE bandwidth.  The choices
can be augmented for specific data-plane technologies.
  """
  __slots__ = ('_path_helper', '_extmethods', '__generic','__otn','__eth_bandwidth',)

  _yang_name = 'te-bandwidth'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__generic = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+(,(0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+))*'}), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-bandwidth', is_config=False)
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    self.__eth_bandwidth = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), restriction_dict={'range': ['0..10000000000']}), is_leaf=True, yang_name="eth-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'information-source-entry', 'unreserved-bandwidth', 'te-bandwidth']

  def _get_generic(self):
    """
    Getter method for generic, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/generic (te-bandwidth)

    YANG Description: Bandwidth specified in a generic format.
    """
    return self.__generic
      
  def _set_generic(self, v, load=False):
    """
    Setter method for generic, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/generic (te-bandwidth)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_generic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_generic() directly.

    YANG Description: Bandwidth specified in a generic format.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+(,(0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+))*'}), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-bandwidth', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """generic must be of a type compatible with te-bandwidth""",
          'defined-type': "ietf-te-topology:te-bandwidth",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+(,(0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+))*'}), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-bandwidth', is_config=False)""",
        })

    self.__generic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_generic(self):
    self.__generic = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+(,(0[xX](0((\\.0?)?[pP](\\+)?0?|(\\.0?))|1(\\.([\\da-fA-F]{0,5}[02468aAcCeE]?)?)?[pP](\\+)?(12[0-7]|1[01]\\d|0?\\d?\\d)?)|0[xX][\\da-fA-F]{1,8}|\\d+))*'}), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-bandwidth', is_config=False)


  def _get_otn(self):
    """
    Getter method for otn, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/otn (container)

    YANG Description: Bandwidth attributes for OTN links
    """
    return self.__otn
      
  def _set_otn(self, v, load=False):
    """
    Setter method for otn, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/otn (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn() directly.

    YANG Description: Bandwidth attributes for OTN links
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=otn.otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)""",
        })

    self.__otn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn(self):
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)


  def _get_eth_bandwidth(self):
    """
    Getter method for eth_bandwidth, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/eth_bandwidth (uint64)

    YANG Description: Available bandwith value expressed in kilobits per second
    """
    return self.__eth_bandwidth
      
  def _set_eth_bandwidth(self, v, load=False):
    """
    Setter method for eth_bandwidth, mapped from YANG variable /networks/network/link/te/information_source_entry/unreserved_bandwidth/te_bandwidth/eth_bandwidth (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_eth_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_eth_bandwidth() directly.

    YANG Description: Available bandwith value expressed in kilobits per second
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), restriction_dict={'range': ['0..10000000000']}), is_leaf=True, yang_name="eth-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """eth_bandwidth must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), restriction_dict={'range': ['0..10000000000']}), is_leaf=True, yang_name="eth-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=False)""",
        })

    self.__eth_bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_eth_bandwidth(self):
    self.__eth_bandwidth = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), restriction_dict={'range': ['0..10000000000']}), is_leaf=True, yang_name="eth-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint64', is_config=False)

  generic = __builtin__.property(_get_generic)
  otn = __builtin__.property(_get_otn)
  eth_bandwidth = __builtin__.property(_get_eth_bandwidth)

  __choices__ = {'technology': {'generic': ['generic']}}
  _pyangbind_elements = OrderedDict([('generic', generic), ('otn', otn), ('eth_bandwidth', eth_bandwidth), ])


