/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.Constraint;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBoxSimple;
import net.sourceforge.plantuml.sequencediagram.graphic.Pushable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintSet {
    private final ParticipantBoxSimple firstBorder;
    private final ParticipantBoxSimple lastborder;
    private final List<Pushable> participantList = new ArrayList<Pushable>();
    private final Map<List<Pushable>, Constraint> constraints = new HashMap<List<Pushable>, Constraint>();

    public ConstraintSet(Collection<? extends Pushable> collection, double d) {
        this.firstBorder = new ParticipantBoxSimple(0.0, "LEFT");
        this.participantList.add(this.firstBorder);
        this.participantList.addAll(collection);
        this.lastborder = new ParticipantBoxSimple(d, "RIGHT");
        this.participantList.add(this.lastborder);
    }

    public String toString() {
        return this.constraints.values().toString();
    }

    public double getMaxX() {
        return this.lastborder.getCenterX(null);
    }

    public Constraint getConstraint(Pushable pushable, Pushable pushable2) {
        if (pushable == null || pushable2 == null || pushable == pushable2) {
            throw new IllegalArgumentException();
        }
        int n = this.participantList.indexOf(pushable);
        int n2 = this.participantList.indexOf(pushable2);
        if (n == -1 || n2 == -1) {
            throw new IllegalArgumentException();
        }
        if (n > n2) {
            return this.getConstraint(pushable2, pushable);
        }
        List<Pushable> list = Arrays.asList(pushable, pushable2);
        Constraint constraint = this.constraints.get(list);
        if (constraint == null) {
            constraint = new Constraint(pushable, pushable2);
            this.constraints.put(list, constraint);
        }
        return constraint;
    }

    public Constraint getConstraintAfter(Pushable pushable) {
        if (pushable == null) {
            throw new IllegalArgumentException();
        }
        return this.getConstraint(pushable, this.getNext(pushable));
    }

    public Constraint getConstraintBefore(Pushable pushable) {
        if (pushable == null) {
            throw new IllegalArgumentException();
        }
        return this.getConstraint(pushable, this.getPrevious(pushable));
    }

    public Pushable getPrevious(Pushable pushable) {
        return this.getOtherParticipant(pushable, -1);
    }

    public Pushable getNext(Pushable pushable) {
        return this.getOtherParticipant(pushable, 1);
    }

    private Pushable getOtherParticipant(Pushable pushable, int n) {
        int n2 = this.participantList.indexOf(pushable);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return this.participantList.get(n2 + n);
    }

    public void takeConstraintIntoAccount(StringBounder stringBounder) {
        for (int i = 1; i < this.participantList.size(); ++i) {
            this.pushEverybody(stringBounder, i);
        }
    }

    private void pushEverybody(StringBounder stringBounder, int n) {
        for (int i = 0; i < this.participantList.size() - n; ++i) {
            Pushable pushable = this.participantList.get(i);
            Pushable pushable2 = this.participantList.get(i + n);
            Constraint constraint = this.getConstraint(pushable, pushable2);
            this.ensureSpaceAfter(stringBounder, pushable, pushable2, constraint.getValue());
        }
    }

    public void pushToLeftParticipantBox(double d, Pushable pushable, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (pushable == null) {
            throw new IllegalArgumentException();
        }
        boolean bl2 = false;
        for (Pushable pushable2 : this.participantList) {
            if (pushable2.equals(pushable)) {
                bl2 = true;
                if (!bl) continue;
            }
            if (!bl2) continue;
            pushable2.pushToLeft(d);
        }
    }

    public void pushToLeft(double d) {
        this.pushToLeftParticipantBox(d, this.firstBorder, true);
    }

    private void ensureSpaceAfter(StringBounder stringBounder, Pushable pushable, Pushable pushable2, double d) {
        if (pushable.equals(pushable2)) {
            throw new IllegalArgumentException();
        }
        if (pushable.getCenterX(stringBounder) > pushable2.getCenterX(stringBounder)) {
            this.ensureSpaceAfter(stringBounder, pushable2, pushable, d);
            return;
        }
        assert (pushable.getCenterX(stringBounder) < pushable2.getCenterX(stringBounder));
        double d2 = pushable2.getCenterX(stringBounder) - pushable.getCenterX(stringBounder);
        if (d2 < d) {
            this.pushToLeftParticipantBox(d - d2, pushable2, true);
        }
    }

    public final Pushable getFirstBorder() {
        return this.firstBorder;
    }

    public final Pushable getLastborder() {
        return this.lastborder;
    }
}

