from typing import Dict

class _Entity:
    def __init__(self, parent=None):
        if (parent is None) or (not isinstance(parent, _Entity)):
            raise AttributeError('parent must be an instance of _Entity')
        self._parent = parent

    @property
    def parent(self) -> '_Entity': return self._parent

    @property
    def database_engine(self) -> object: return self._parent.database_engine

    def load(self):
        raise NotImplementedError()

    def create(self):
        raise NotImplementedError()

    def delete(self):
        raise NotImplementedError()

    def dump(self) -> Dict:
        raise NotImplementedError()
