import grpc, logging
from typing import Optional
from common.Constants import DEFAULT_CONTEXT_UUID
from common.proto.context_pb2 import Service, ServiceId, Slice, SliceId
from context.client.ContextClient import ContextClient

LOGGER = logging.getLogger(__name__)

def get_service(
        context_client : ContextClient, service_uuid : str, context_uuid : str = DEFAULT_CONTEXT_UUID
    ) -> Optional[Service]:
    try:
        # pylint: disable=no-member
        service_id = ServiceId()
        service_id.context_id.context_uuid.uuid = context_uuid
        service_id.service_uuid.uuid = service_uuid
        service_readonly = context_client.GetService(service_id)
        service = Service()
        service.CopyFrom(service_readonly)
        return service
    except grpc.RpcError:
        #LOGGER.exception('Unable to get service({:s} / {:s})'.format(str(context_uuid), str(service_uuid)))
        return None

def get_slice(
        context_client : ContextClient, slice_uuid : str, context_uuid : str = DEFAULT_CONTEXT_UUID
    ) -> Optional[Slice]:
    try:
        # pylint: disable=no-member
        slice_id = SliceId()
        slice_id.context_id.context_uuid.uuid = context_uuid
        slice_id.slice_uuid.uuid = slice_uuid
        slice_readonly = context_client.GetSlice(slice_id)
        slice_ = Slice()
        slice_.CopyFrom(slice_readonly)
        return slice_
    except grpc.RpcError:
        #LOGGER.exception('Unable to get slice({:s} / {:s})'.format(str(context_uuid), str(slice_uuid)))
        return None
