import logging, os, signal, sys, threading
import time

from monitoring.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD, LOG_LEVEL, METRICS_PORT

from common.logger import getJSONLogger
from monitoring.service.MonitoringService import MonitoringService

LOGGER = getJSONLogger('monitoringservice-server')
LOGGER.setLevel('DEBUG')

from prometheus_client import start_http_server

terminate = threading.Event()
logger = None

def signal_handler(signal, frame):
    global terminate, logger
    logger.warning('Terminate signal received')
    terminate.set()

def main():
    global terminate, logger

    service_port = GRPC_SERVICE_PORT
    max_workers  = GRPC_MAX_WORKERS
    grace_period = GRPC_GRACE_PERIOD
    log_level    = LOG_LEVEL
    metrics_port = METRICS_PORT

    logging.basicConfig(level=log_level)
    logger = logging.getLogger(__name__)

    signal.signal(signal.SIGINT,  signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    logger.info('Starting...')
    # Start metrics server
    start_http_server(metrics_port)

    # Starting monitoring service
    grpc_service = MonitoringService(port=service_port, max_workers=max_workers, grace_period=grace_period)
    grpc_service.start()

    # Wait for Ctrl+C or termination signal
    while not terminate.wait(timeout=0.1): pass

    logger.info('Terminating...')
    grpc_service.stop()

    logger.info('Bye')
    return 0

if __name__ == '__main__':
    sys.exit(main())