from enum import Enum

class DeviceTypeQueryFieldEnum(Enum):
    OPTICAL_ROADM       = 'optical-roadm'
    OPTICAL_TRANDPONDER = 'optical-trandponder'
    PACKET_ROUTER       = 'packet-router'
    PACKET_SWITCH       = 'packet-switch'

class ProtocolQueryFieldEnum(Enum):
    SOFTWARE = 'software'
    GRPC     = 'grpc'
    RESTAPI  = 'restapi'
    NETCONF  = 'netconf'
    GNMI     = 'gnmi'
    RESTCONF = 'restconf'

class DataModelQueryFieldEnum(Enum):
    EMULATED              = 'emu'
    OPENCONFIG            = 'oc'
    P4                    = 'p4'
    TRANSPORT_API         = 'tapi'
    IETF_NETWORK_TOPOLOGY = 'ietf-netw-topo'
    ONF_TR_352            = 'onf-tr-352'

# Map allowed query fields to allowed values per query field. If no restriction (free text) None is specified
QUERY_FIELDS = {
    'device_type'  : {i.value for i in DeviceTypeQueryFieldEnum},
    'protocol'     : {i.value for i in ProtocolQueryFieldEnum},
    'data_model'   : {i.value for i in DataModelQueryFieldEnum},
    'vendor'       : None,
    'model'        : None,
    'serial_number': None,
}
