# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import primary_path
from . import backup_path
from . import tunnel_termination_points
from . import tunnels
class underlay(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/connectivity-matrix/underlay. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Attributes of the TE link underlay.
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__primary_path','__backup_path','__protection_type','__tunnel_termination_points','__tunnels',)

  _yang_name = 'underlay'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)
    self.__primary_path = YANGDynClass(base=primary_path.primary_path, is_container='container', yang_name="primary-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__backup_path = YANGDynClass(base=YANGListType("index",backup_path.backup_path, yang_name="backup-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="backup-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    self.__protection_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__tunnel_termination_points = YANGDynClass(base=tunnel_termination_points.tunnel_termination_points, is_container='container', yang_name="tunnel-termination-points", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__tunnels = YANGDynClass(base=tunnels.tunnels, is_container='container', yang_name="tunnels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'connectivity-matrix', 'underlay']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/enabled (boolean)

    YANG Description: 'true' if the underlay is enabled.
'false' if the underlay is disabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: 'true' if the underlay is enabled.
'false' if the underlay is disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)


  def _get_primary_path(self):
    """
    Getter method for primary_path, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/primary_path (container)

    YANG Description: The service path on the underlay topology that
supports this link.
    """
    return self.__primary_path
      
  def _set_primary_path(self, v, load=False):
    """
    Setter method for primary_path, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/primary_path (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_path() directly.

    YANG Description: The service path on the underlay topology that
supports this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=primary_path.primary_path, is_container='container', yang_name="primary-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_path must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=primary_path.primary_path, is_container='container', yang_name="primary-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__primary_path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_path(self):
    self.__primary_path = YANGDynClass(base=primary_path.primary_path, is_container='container', yang_name="primary-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_backup_path(self):
    """
    Getter method for backup_path, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/backup_path (list)

    YANG Description: A list of backup service paths on the underlay topology that
protect the underlay primary path.  If the primary path is
not protected, the list contains zero elements.  If the
primary path is protected, the list contains one or more
elements.
    """
    return self.__backup_path
      
  def _set_backup_path(self, v, load=False):
    """
    Setter method for backup_path, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/backup_path (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backup_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backup_path() directly.

    YANG Description: A list of backup service paths on the underlay topology that
protect the underlay primary path.  If the primary path is
not protected, the list contains zero elements.  If the
primary path is protected, the list contains one or more
elements.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",backup_path.backup_path, yang_name="backup-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="backup-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backup_path must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",backup_path.backup_path, yang_name="backup-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="backup-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__backup_path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backup_path(self):
    self.__backup_path = YANGDynClass(base=YANGListType("index",backup_path.backup_path, yang_name="backup-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="backup-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)


  def _get_protection_type(self):
    """
    Getter method for protection_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/protection_type (identityref)

    YANG Description: Underlay protection type desired for this link.
    """
    return self.__protection_type
      
  def _set_protection_type(self, v, load=False):
    """
    Setter method for protection_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/protection_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protection_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protection_type() directly.

    YANG Description: Underlay protection type desired for this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protection_type must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__protection_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protection_type(self):
    self.__protection_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute-extra': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-reroute': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-n': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-unidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-bidir-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:lsp-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_tunnel_termination_points(self):
    """
    Getter method for tunnel_termination_points, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/tunnel_termination_points (container)

    YANG Description: Underlay TTPs desired for this link.
    """
    return self.__tunnel_termination_points
      
  def _set_tunnel_termination_points(self, v, load=False):
    """
    Setter method for tunnel_termination_points, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/tunnel_termination_points (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tunnel_termination_points is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tunnel_termination_points() directly.

    YANG Description: Underlay TTPs desired for this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=tunnel_termination_points.tunnel_termination_points, is_container='container', yang_name="tunnel-termination-points", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tunnel_termination_points must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=tunnel_termination_points.tunnel_termination_points, is_container='container', yang_name="tunnel-termination-points", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__tunnel_termination_points = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tunnel_termination_points(self):
    self.__tunnel_termination_points = YANGDynClass(base=tunnel_termination_points.tunnel_termination_points, is_container='container', yang_name="tunnel-termination-points", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_tunnels(self):
    """
    Getter method for tunnels, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/tunnels (container)

    YANG Description: Underlay TE tunnels supporting this TE link.
    """
    return self.__tunnels
      
  def _set_tunnels(self, v, load=False):
    """
    Setter method for tunnels, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/underlay/tunnels (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tunnels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tunnels() directly.

    YANG Description: Underlay TE tunnels supporting this TE link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=tunnels.tunnels, is_container='container', yang_name="tunnels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tunnels must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=tunnels.tunnels, is_container='container', yang_name="tunnels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__tunnels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tunnels(self):
    self.__tunnels = YANGDynClass(base=tunnels.tunnels, is_container='container', yang_name="tunnels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  primary_path = __builtin__.property(_get_primary_path, _set_primary_path)
  backup_path = __builtin__.property(_get_backup_path, _set_backup_path)
  protection_type = __builtin__.property(_get_protection_type, _set_protection_type)
  tunnel_termination_points = __builtin__.property(_get_tunnel_termination_points, _set_tunnel_termination_points)
  tunnels = __builtin__.property(_get_tunnels, _set_tunnels)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('primary_path', primary_path), ('backup_path', backup_path), ('protection_type', protection_type), ('tunnel_termination_points', tunnel_termination_points), ('tunnels', tunnels), ])


