# RFC 8466 - L2VPN Service Model (L2SM)
# Ref: https://datatracker.ietf.org/doc/html/rfc8466

from flask_restful import Resource
from compute.service.rest_server.RestServer import RestServer
from .L2VPN_Services import L2VPN_Services
from .L2VPN_Service import L2VPN_Service
from .L2VPN_SiteNetworkAccesses import L2VPN_SiteNetworkAccesses

URL_PREFIX      = '/ietf-l2vpn-svc:l2vpn-svc'

def _add_resource(rest_server : RestServer, resource : Resource, *urls, **kwargs):
    urls = [(URL_PREFIX + url) for url in urls]
    rest_server.add_resource(resource, *urls, **kwargs)

def register_ietf_l2vpn(rest_server : RestServer):
    _add_resource(rest_server, L2VPN_Services,
        '/vpn-services')
    _add_resource(rest_server, L2VPN_Service,
        '/vpn-services/vpn-service=<vpn_id>', '/vpn-services/vpn-service=<vpn_id>/')
    _add_resource(rest_server, L2VPN_SiteNetworkAccesses,
        '/sites/site=<site_id>/site-network-accesses', '/sites/site=<site_id>/site-network-accesses/')
