package eu.teraflow.automation.context;

import eu.teraflow.automation.device.Device;
import eu.teraflow.automation.device.model.DeviceId;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class ContextServiceImpl implements ContextService {

    private final ContextGateway contextGateway;

    @Inject
    public ContextServiceImpl(ContextGateway contextGateway) {
        this.contextGateway = contextGateway;
    }

    @Override
    public Uni<Device> getDevice(DeviceId deviceId) {

        return contextGateway.getDevice(deviceId);
    }
}
