# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from typing import Dict
from flask.json import jsonify
from flask_restful import Resource
from flask import request
from compute.service.rest_server.nbi_plugins.tools.Authentication import HTTP_AUTH
from compute.service.rest_server.nbi_plugins.tools.HttpStatusCodes import HTTP_BADREQUEST, HTTP_OK
from werkzeug.exceptions import UnsupportedMediaType

LOGGER = logging.getLogger(__name__)

class NSS_Services(Resource):
    @HTTP_AUTH.login_required
    def get(self):    
        response = jsonify({"message": "All went well!"})
        response.status_code

        # TODO Return list of current network-slice-services
        return response

    @HTTP_AUTH.login_required
    def post(self):
        if not request.is_json: raise UnsupportedMediaType('JSON payload is required')
        request_data : Dict = request.json
        LOGGER.debug('POST Request: {:s}'.format(str(request_data)))

        # TODO Parse network-slice-service request and cascade to Slice and Policy componentes
        response = jsonify({"message" : "POST message received correctly"})
        response.status_code = HTTP_OK
        return response