from flask.json import jsonify
from flask_restful import Resource
from common.Constants import DEFAULT_CONTEXT_UUID
from context.service.database.api.Database import Database

class Context(Resource):
    def __init__(self, database : Database) -> None:
        super().__init__()
        self.database = database

    def get(self):
        with self.database:
            return jsonify(self.database.context(DEFAULT_CONTEXT_UUID).dump())
