from common.orm.fields.IntegerField import IntegerField
from common.orm.fields.StringField import StringField
from common.orm.model.Model import Model
from common.orm.fields.ForeignKeyField import ForeignKeyField
from common.orm.fields.PrimaryKeyField import PrimaryKeyField

class ContextModel(Model):
    pk = PrimaryKeyField()

class TopologyModel(Model):
    pk = PrimaryKeyField()
    context_fk = ForeignKeyField(ContextModel)

class DeviceModel(Model):
    pk = PrimaryKeyField()
    device_type = StringField()

class TopologyDeviceModel(Model):
    pk = PrimaryKeyField()
    topology_fk = ForeignKeyField(TopologyModel)
    device_fk = ForeignKeyField(DeviceModel)

class DeviceConfigModel(Model):
    pk = PrimaryKeyField()
    device_fk = ForeignKeyField(DeviceModel)

class DeviceConfigRuleModel(Model):
    pk = PrimaryKeyField()
    device_config_fk = ForeignKeyField(DeviceConfigModel)
    position = IntegerField(min_value=0, required=True)
    key = StringField(required=True)
    value = StringField(required=True)

#message Device {
#  DeviceConfig device_config = 3;
#  DeviceOperationalStatus devive_operational_status = 4;
#  repeated DeviceDriverEnum device_drivers = 5;
#  repeated EndPoint endpoints = 6;
#}

class LinkModel(Model):
    link_uuid = PrimaryKeyField()

class TopologyLinkModel(Model):
    topology_fk = ForeignKeyField(TopologyModel)
    link_fk = ForeignKeyField(LinkModel)

class EndPointModel(Model):
    endpoint_uuid = PrimaryKeyField()

class ServiceModel(Model):
    endpoint_uuid = PrimaryKeyField()


# TODO: implement query methods to find, for instance, topologies belonging to a context
#  from Context instance, retrieve references of a specific Model type
