from enum import Enum

class ServiceType(Enum):
    UNKNOWN = 0
    L3NM = 1
    L2NM = 2
    TAPI_CONNECTIVITY_SERVICE = 3

ANY_TO_ENUM = {
    0: ServiceType.UNKNOWN,
    1: ServiceType.L3NM,
    2: ServiceType.L2NM,
    3: ServiceType.TAPI_CONNECTIVITY_SERVICE,

    '0': ServiceType.UNKNOWN,
    '1': ServiceType.L3NM,
    '2': ServiceType.L2NM,
    '3': ServiceType.TAPI_CONNECTIVITY_SERVICE,

    'UNKNOWN': ServiceType.UNKNOWN,
    'L3NM': ServiceType.L3NM,
    'L2NM': ServiceType.L2NM,
    'TAPI_CONNECTIVITY_SERVICE': ServiceType.TAPI_CONNECTIVITY_SERVICE,
}

def servicetype_enum_values():
    return {m.value for m in ServiceType.__members__.values()}

def to_servicetype_enum(int_or_str):
    if isinstance(int_or_str, str): int_or_str = int_or_str.upper()
    return ANY_TO_ENUM.get(int_or_str)
