from __future__ import annotations
from typing import TYPE_CHECKING, Dict
from ....entity._Entity import _Entity
from ...Keys import KEY_LINK_ENDPOINT
from ..device.Endpoint import Endpoint as DeviceEndpoint

if TYPE_CHECKING:
    from ...Context import Context
    from ..Topology import Topology
    from .Link import Link

VALIDATORS = {
    'device_uuid': lambda v: v is not None and isinstance(v, str) and (len(v) > 0),
    'endpoint_uuid': lambda v: v is not None and isinstance(v, str) and (len(v) > 0),
}

TRANSCODERS = {} # no transcoding applied to attributes

class Endpoint(_Entity):
    def __init__(self, endpoint_uuid : str, parent : 'Link'):
        super().__init__(parent, endpoint_uuid, KEY_LINK_ENDPOINT, VALIDATORS, TRANSCODERS)

    @property
    def parent(self) -> 'Link': return self._parent

    @property
    def context(self) -> 'Context': return self.parent.context

    @property
    def context_uuid(self) -> str: return self.parent.context_uuid

    @property
    def topology(self) -> 'Topology': return self.parent.topology

    @property
    def topology_uuid(self) -> str: return self.parent.topology_uuid

    @property
    def link(self) -> 'Link': return self.parent

    @property
    def link_uuid(self) -> str: return self.parent.link_uuid

    @property
    def endpoint_uuid(self) -> str: return self._entity_uuid

    def create(self, endpoint : DeviceEndpoint) -> 'Endpoint':
        self.update(update_attributes={
            'device_uuid': endpoint.device_uuid,
            'endpoint_uuid': endpoint.endpoint_uuid,
        })
        self.parent.endpoints.add(self.endpoint_uuid)
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'Endpoint':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        self.attributes.delete()
        self.parent.endpoints.delete(self.endpoint_uuid)

    def dump_id(self) -> Dict:
        attributes = self.attributes.get()
        device_uuid = attributes.get('device_uuid', None)
        endpoint_uuid = attributes.get('endpoint_uuid', None)
        endpoint = self.topology.device(device_uuid).endpoint(endpoint_uuid)
        return endpoint.dump_id()

    def dump(self) -> Dict:
        return self.dump_id()
