# RESTCONF .well-known endpoint (RFC 8040)
class WellKnownHostMeta(Resource):
    def get(self):
        response = {
            "restconf": {
                "capabilities": [
                    "urn:ietf:params:restconf:capability:defaults:1.0",
                    "urn:ietf:params:restconf:capability:depth:1.0",
                    "urn:ietf:params:restconf:capability:with-defaults:1.0"
                ],
                "media-types": [
                    "application/yang-data+json",
                    "application/yang-data+xml"
                ]
            }
        }
        return jsonify(response)

# Register the RESTCONF .well-known endpoint
api.add_resource(WellKnownHostMeta, "/.well-known/host-meta")