# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


from nbi.service.NbiApplication import NbiApplication
from .Resources import RESOURCE_DESCRIPTORS

def register_health_probes(nbi_app : NbiApplication):
    for endpoint_name, resource_class, resource_url in RESOURCE_DESCRIPTORS:
        nbi_app.add_rest_api_resource(resource_class, resource_url, endpoint=endpoint_name)
