import time
from flask_restful import Resource

START_TIME = time.time()

class HealthProbe(Resource):
    def get(self):
        uptime = time.time() - START_TIME
        return {'status': 'ready', 'uptime': uptime}, 200
        #return {'status': 'not ready'}, 503

RESOURCE_DESCRIPTORS = [
    # endpoint_name, resource_class, resource_url
    ('sys.probe.healthz', HealthProbe, '/healthz'),
]
